/*
 * Decompiled with CFR 0.152.
 */
package internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public class FileHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileHelper.class);
    private static final String CLASSPATH_PATH_SEPARATOR = "/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(@Nonnull String path) throws FileNotFoundException {
        if (!FileHelper.isClasspath(path) && new File(path).exists()) {
            try (FileInputStream fis = new FileInputStream(path);){
                logger.debug("File loaded from system path: {}", (Object)path);
                byte[] byArray = IOUtils.toByteArray((InputStream)fis);
                return byArray;
            }
        }
        if (FileHelper.class.getResource(FileHelper.classpath(path)) == null) throw new FileNotFoundException("Unable to load file from path: " + path);
        logger.debug("File loaded from classpath location: {}", (Object)path);
        return IOUtils.toByteArray((InputStream)FileHelper.class.getResourceAsStream(FileHelper.classpath(path)));
    }

    public static String path(String first, String second) {
        return FileHelper.isClasspath(first) ? FileHelper.classpathPath(first, second) : Paths.get(first, second).toString();
    }

    private static String classpathPath(String first, String second) {
        if (first.endsWith(CLASSPATH_PATH_SEPARATOR) && second.startsWith(CLASSPATH_PATH_SEPARATOR)) {
            return first + second.substring(1);
        }
        if (!first.endsWith(CLASSPATH_PATH_SEPARATOR) && !second.startsWith(CLASSPATH_PATH_SEPARATOR)) {
            return first + CLASSPATH_PATH_SEPARATOR + second;
        }
        return first + second;
    }

    private static String classpath(String path) {
        return path.replace("classpath:", "");
    }

    private static boolean isClasspath(String path) {
        return path.startsWith("classpath:");
    }
}

