/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;
import model.Attachment;
import model.Stream;
import model.User;
import utils.SymMessageParser;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InboundMessage {
    private String messageId;
    private Long timestamp;
    private String message;
    private InboundMessage sharedMessage;
    private String data;
    private List<Attachment> attachments;
    private User user;
    private Stream stream;
    private Boolean externalRecipients;
    private String diagnostic;
    private String userAgent;
    private String originalFormat;
    private String disclaimer;
    private String sid;

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public InboundMessage getSharedMessage() {
        return this.sharedMessage;
    }

    public void setSharedMessage(InboundMessage sharedMessage) {
        this.sharedMessage = sharedMessage;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public Boolean getExternalRecipients() {
        return this.externalRecipients;
    }

    public void setExternalRecipients(Boolean externalRecipients) {
        this.externalRecipients = externalRecipients;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(String diagnostic) {
        this.diagnostic = diagnostic;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getOriginalFormat() {
        return this.originalFormat;
    }

    public void setOriginalFormat(String originalFormat) {
        this.originalFormat = originalFormat;
    }

    public String getDisclaimer() {
        return this.disclaimer;
    }

    public void setDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getMessageText() {
        if (SymMessageParser.getInstance() == null) {
            return null;
        }
        return SymMessageParser.getInstance().messageToText(this.message, this.data);
    }

    public List<String> getHashtags() {
        return SymMessageParser.getHashtags(this);
    }

    public List<String> getCashtags() {
        return SymMessageParser.getCashtags(this);
    }

    public List<Long> getMentions() {
        return SymMessageParser.getMentions(this);
    }

    public Map<String, String> getEmojis() {
        return SymMessageParser.getEmojis(this);
    }
}

