/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import clients.symphony.api.DatafeedClient;
import java.util.ArrayList;
import java.util.List;
import listeners.ConnectionListener;
import listeners.DatafeedListener;
import listeners.ElementsListener;
import listeners.IMListener;
import listeners.RoomListener;
import model.DatafeedEvent;
import model.Initiator;
import model.events.MessageSent;
import model.events.RoomCreated;
import model.events.RoomDeactivated;
import model.events.RoomMemberDemotedFromOwner;
import model.events.RoomMemberPromotedToOwner;
import model.events.RoomUpdated;
import model.events.UserJoinedRoom;
import model.events.UserLeftRoom;
import services.IDatafeedEventsService;

abstract class AbstractDatafeedEventsService
implements IDatafeedEventsService {
    protected final SymBotClient botClient;
    protected final DatafeedClient datafeedClient;
    protected List<RoomListener> roomListeners = new ArrayList<RoomListener>();
    protected List<IMListener> imListeners = new ArrayList<IMListener>();
    protected List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    protected List<ElementsListener> elementsListeners = new ArrayList<ElementsListener>();

    public AbstractDatafeedEventsService(SymBotClient client) {
        this.botClient = client;
        this.datafeedClient = this.botClient.getDatafeedClient();
    }

    @Override
    public void addListeners(DatafeedListener ... listeners) {
        for (DatafeedListener listener : listeners) {
            if (listener instanceof RoomListener) {
                this.addRoomListener((RoomListener)listener);
                continue;
            }
            if (listener instanceof IMListener) {
                this.addIMListener((IMListener)listener);
                continue;
            }
            if (listener instanceof ConnectionListener) {
                this.addConnectionsListener((ConnectionListener)listener);
                continue;
            }
            if (!(listener instanceof ElementsListener)) continue;
            this.addElementsListener((ElementsListener)listener);
        }
    }

    @Override
    public void removeListeners(DatafeedListener ... listeners) {
        for (DatafeedListener listener : listeners) {
            if (listener instanceof RoomListener) {
                this.removeRoomListener((RoomListener)listener);
                continue;
            }
            if (listener instanceof IMListener) {
                this.removeIMListener((IMListener)listener);
                continue;
            }
            if (listener instanceof ConnectionListener) {
                this.removeConnectionsListener((ConnectionListener)listener);
                continue;
            }
            if (!(listener instanceof ElementsListener)) continue;
            this.removeElementsListener((ElementsListener)listener);
        }
    }

    @Override
    public void addRoomListener(RoomListener listener) {
        this.roomListeners.add(listener);
    }

    @Override
    public void removeRoomListener(RoomListener listener) {
        this.roomListeners.remove(listener);
    }

    @Override
    public void addIMListener(IMListener listener) {
        this.imListeners.add(listener);
    }

    @Override
    public void removeIMListener(IMListener listener) {
        this.imListeners.remove(listener);
    }

    @Override
    public void addConnectionsListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionsListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public void addElementsListener(ElementsListener listener) {
        this.elementsListeners.add(listener);
    }

    @Override
    public void removeElementsListener(ElementsListener listener) {
        this.elementsListeners.remove(listener);
    }

    protected void handleEvents(List<DatafeedEvent> datafeedEvents) {
        block30: for (DatafeedEvent event : datafeedEvents) {
            if (event == null || event.getInitiator().getUser().getUserId().equals(this.botClient.getBotUserId())) continue;
            Initiator initiator = event.getInitiator();
            switch (event.getType()) {
                case "MESSAGESENT": {
                    MessageSent messageSent = event.getPayload().getMessageSent();
                    messageSent.setInitiator(initiator);
                    if (messageSent.getMessage().getStream().getStreamType().equals("ROOM")) {
                        for (RoomListener roomListener : this.roomListeners) {
                            roomListener.onRoomMessage(messageSent.getMessage());
                        }
                        continue block30;
                    }
                    for (IMListener iMListener : this.imListeners) {
                        iMListener.onIMMessage(messageSent.getMessage());
                    }
                    continue block30;
                }
                case "INSTANTMESSAGECREATED": {
                    for (IMListener iMListener : this.imListeners) {
                        iMListener.onIMCreated(event.getPayload().getInstantMessageCreated().getStream());
                    }
                    continue block30;
                }
                case "ROOMCREATED": {
                    RoomCreated roomCreated = event.getPayload().getRoomCreated();
                    roomCreated.setInitiator(initiator);
                    for (Object listener : this.roomListeners) {
                        listener.onRoomCreated(roomCreated);
                    }
                    continue block30;
                }
                case "ROOMUPDATED": {
                    Object listener;
                    RoomUpdated roomUpdated = event.getPayload().getRoomUpdated();
                    roomUpdated.setInitiator(initiator);
                    listener = this.roomListeners.iterator();
                    while (listener.hasNext()) {
                        RoomListener roomListener = listener.next();
                        roomListener.onRoomUpdated(roomUpdated);
                    }
                    continue block30;
                }
                case "ROOMDEACTIVATED": {
                    RoomDeactivated roomDeactivated = event.getPayload().getRoomDeactivated();
                    roomDeactivated.setInitiator(initiator);
                    for (Object listener : this.roomListeners) {
                        listener.onRoomDeactivated(roomDeactivated);
                    }
                    continue block30;
                }
                case "ROOMREACTIVATED": {
                    for (Object listener : this.roomListeners) {
                        listener.onRoomReactivated(event.getPayload().getRoomReactivated().getStream());
                    }
                    continue block30;
                }
                case "USERJOINEDROOM": {
                    Object listener;
                    UserJoinedRoom userJoinedRoom = event.getPayload().getUserJoinedRoom();
                    userJoinedRoom.setInitiator(initiator);
                    listener = this.roomListeners.iterator();
                    while (listener.hasNext()) {
                        RoomListener roomListener = (RoomListener)listener.next();
                        roomListener.onUserJoinedRoom(userJoinedRoom);
                    }
                    continue block30;
                }
                case "USERLEFTROOM": {
                    UserLeftRoom userLeftRoom = event.getPayload().getUserLeftRoom();
                    userLeftRoom.setInitiator(initiator);
                    for (Object listener3 : this.roomListeners) {
                        listener3.onUserLeftRoom(userLeftRoom);
                    }
                    continue block30;
                }
                case "ROOMMEMBERPROMOTEDTOOWNER": {
                    Object listener3;
                    RoomMemberPromotedToOwner roomMemberPromotedToOwner = event.getPayload().getRoomMemberPromotedToOwner();
                    roomMemberPromotedToOwner.setInitiator(initiator);
                    listener3 = this.roomListeners.iterator();
                    while (listener3.hasNext()) {
                        RoomListener listener = listener3.next();
                        listener.onRoomMemberPromotedToOwner(roomMemberPromotedToOwner);
                    }
                    continue block30;
                }
                case "ROOMMEMBERDEMOTEDFROMOWNER": {
                    RoomMemberDemotedFromOwner roomMemberDemotedFromOwner = event.getPayload().getRoomMemberDemotedFromOwner();
                    roomMemberDemotedFromOwner.setInitiator(initiator);
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomMemberDemotedFromOwner(event.getPayload().getRoomMemberDemotedFromOwner());
                    }
                    continue block30;
                }
                case "CONNECTIONACCEPTED": {
                    for (ConnectionListener connectionListener : this.connectionListeners) {
                        connectionListener.onConnectionAccepted(event.getInitiator().getUser());
                    }
                    continue block30;
                }
                case "CONNECTIONREQUESTED": {
                    for (ConnectionListener connectionListener : this.connectionListeners) {
                        connectionListener.onConnectionRequested(event.getInitiator().getUser());
                    }
                    continue block30;
                }
                case "SYMPHONYELEMENTSACTION": {
                    for (ElementsListener elementsListener : this.elementsListeners) {
                        elementsListener.onElementsAction(event.getInitiator().getUser(), event.getPayload().getSymphonyElementsAction());
                    }
                    continue block30;
                }
            }
        }
    }
}

