/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import clients.symphony.api.FirehoseClient;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import listeners.FirehoseListener;
import model.DatafeedEvent;
import model.events.MessageSent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.ActionFirehose;

public class ActionFirehoseImpl
implements ActionFirehose {
    private final Logger logger = LoggerFactory.getLogger(ActionFirehoseImpl.class);
    private SymBotClient botClient;

    public ActionFirehoseImpl(SymBotClient botClient) {
        this.botClient = botClient;
    }

    @Override
    public List<DatafeedEvent> actionReadFirehose(FirehoseClient firehoseClient, String firehoseId) {
        try {
            return firehoseClient.readFirehose(firehoseId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<List<DatafeedEvent>> actionHandleEvents(List<DatafeedEvent> events, List<FirehoseListener> listeners) {
        if (events != null || !events.isEmpty()) {
            this.handleEvents(events, listeners);
        }
        return null;
    }

    private void handleEvents(List<DatafeedEvent> firehoseEvents, List<FirehoseListener> listeners) {
        block28: for (DatafeedEvent event : firehoseEvents) {
            if (event.getInitiator().getUser().getUserId().equals(this.botClient.getBotUserId())) continue;
            switch (event.getType()) {
                case "MESSAGESENT": {
                    MessageSent messageSent = event.getPayload().getMessageSent();
                    if (messageSent.getMessage().getStream().getStreamType().equals("ROOM")) {
                        for (FirehoseListener listener : listeners) {
                            listener.onRoomMessage(messageSent.getMessage());
                        }
                        continue block28;
                    }
                    for (FirehoseListener listener : listeners) {
                        listener.onIMMessage(messageSent.getMessage());
                    }
                    continue block28;
                }
                case "INSTANTMESSAGECREATED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onIMCreated(event.getPayload().getInstantMessageCreated().getStream());
                    }
                    continue block28;
                }
                case "ROOMCREATED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomCreated(event.getPayload().getRoomCreated());
                    }
                    continue block28;
                }
                case "ROOMUPDATED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomUpdated(event.getPayload().getRoomUpdated());
                    }
                    continue block28;
                }
                case "ROOMDEACTIVATED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomDeactivated(event.getPayload().getRoomDeactivated());
                    }
                    continue block28;
                }
                case "ROOMREACTIVATED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomReactivated(event.getPayload().getRoomReactivated().getStream());
                    }
                    continue block28;
                }
                case "USERJOINEDROOM": {
                    for (FirehoseListener listener : listeners) {
                        listener.onUserJoinedRoom(event.getPayload().getUserJoinedRoom());
                    }
                    continue block28;
                }
                case "USERLEFTROOM": {
                    for (FirehoseListener listener : listeners) {
                        listener.onUserLeftRoom(event.getPayload().getUserLeftRoom());
                    }
                    continue block28;
                }
                case "ROOMMEMBERPROMOTEDTOOWNER": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomMemberPromotedToOwner(event.getPayload().getRoomMemberPromotedToOwner());
                    }
                    continue block28;
                }
                case "ROOMMEMBERDEMOTEDFROMOWNER": {
                    for (FirehoseListener listener : listeners) {
                        listener.onRoomMemberDemotedFromOwner(event.getPayload().getRoomMemberDemotedFromOwner());
                    }
                    continue block28;
                }
                case "CONNECTIONACCEPTED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onConnectionAccepted(event.getPayload().getConnectionAccepted().getFromUser());
                    }
                    continue block28;
                }
                case "CONNECTIONREQUESTED": {
                    for (FirehoseListener listener : listeners) {
                        listener.onConnectionRequested(event.getPayload().getConnectionRequested().getToUser());
                    }
                    continue block28;
                }
            }
        }
    }
}

