/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import configuration.LoadBalancingMethod;
import configuration.SymConfig;
import configuration.SymLoadBalancedConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import model.DatafeedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.AbstractDatafeedEventsService;

class DatafeedEventsServiceV1
extends AbstractDatafeedEventsService {
    private final Logger logger = LoggerFactory.getLogger(DatafeedEventsServiceV1.class);
    private static final int MAX_BACKOFF_TIME = 300;
    private String datafeedId = null;
    private ExecutorService pool;
    private AtomicBoolean stop = new AtomicBoolean();
    private static int THREADPOOL_SIZE;
    private static int TIMEOUT_NO_OF_SECS;

    public DatafeedEventsServiceV1(SymBotClient client) {
        super(client);
        int threadPoolSize = client.getConfig().getDatafeedEventsThreadpoolSize();
        THREADPOOL_SIZE = threadPoolSize > 0 ? threadPoolSize : 5;
        this.resetTimeout();
        if (this.botClient.getConfig().getReuseDatafeedID() == null || this.botClient.getConfig().getReuseDatafeedID().booleanValue()) {
            try {
                File file = this.botClient.getDatafeedIdFile();
                Path datafeedIdPath = Paths.get(file.getPath(), new String[0]);
                String[] persistedDatafeed = Files.readAllLines(datafeedIdPath).get(0).split("@");
                this.datafeedId = persistedDatafeed[0];
                if (client.getConfig() instanceof SymLoadBalancedConfig) {
                    SymLoadBalancedConfig lbConfig = (SymLoadBalancedConfig)client.getConfig();
                    String[] agentHostPort = persistedDatafeed[1].split(":");
                    if (lbConfig.getLoadBalancing().getMethod() == LoadBalancingMethod.external) {
                        lbConfig.setActualAgentHost(agentHostPort[0]);
                    } else {
                        int previousIndex = lbConfig.getAgentServers().indexOf(agentHostPort[0]);
                        lbConfig.setCurrentAgentIndex(previousIndex);
                    }
                }
                this.logger.info("Using previous datafeed id: {}", (Object)this.datafeedId);
            }
            catch (IOException e) {
                this.logger.info("No previous datafeed id file");
            }
        }
        while (this.datafeedId == null) {
            try {
                this.datafeedId = this.datafeedClient.createDatafeed();
                this.resetTimeout();
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
        this.readDatafeed();
        this.stop.set(false);
    }

    private void resetTimeout() {
        int errorTimeout = this.botClient.getConfig().getDatafeedEventsErrorTimeout();
        TIMEOUT_NO_OF_SECS = errorTimeout > 0 ? errorTimeout : 30;
    }

    @Override
    public void readDatafeed() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        this.pool = Executors.newFixedThreadPool(THREADPOOL_SIZE);
        CompletableFuture.supplyAsync(() -> {
            while (!this.stop.get()) {
                CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        List<DatafeedEvent> events = this.datafeedClient.readDatafeed(this.datafeedId, new String[0]);
                        this.resetTimeout();
                        return events;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, this.pool).exceptionally(ex -> {
                    this.handleError((Throwable)ex);
                    return Collections.emptyList();
                })).thenApply(events -> {
                    if (events != null && !events.isEmpty()) {
                        this.handleEvents((List<DatafeedEvent>)events);
                    }
                    return Collections.emptyList();
                });
                try {
                    ((CompletableFuture)future).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.error("Error trying to read datafeed", (Throwable)e);
                }
            }
            return Collections.emptyList();
        }, this.pool);
    }

    @Override
    public void stopDatafeedService() {
        if (!this.stop.get()) {
            this.stop.set(true);
        }
    }

    @Override
    public void restartDatafeedService() {
        if (this.stop.get()) {
            this.stop.set(false);
        }
        this.datafeedId = this.datafeedClient.createDatafeed();
        this.readDatafeed();
    }

    private void handleError(Throwable e) {
        String errMsg = e.getMessage();
        if (errMsg.endsWith("SocketTimeoutException: Read timed out")) {
            int connectionTimeoutSeconds = this.botClient.getConfig().getConnectionTimeout() / 1000;
            this.logger.error("Connection timed out after {} seconds", (Object)connectionTimeoutSeconds);
        } else if (errMsg.endsWith("Origin Error") || errMsg.endsWith("Service Unavailable") || errMsg.endsWith("Bad Gateway")) {
            this.logger.error("Pod is unavailable");
        } else if (errMsg.contains("Could not find a datafeed with the")) {
            this.logger.error(errMsg);
        } else {
            this.logger.error("An unknown error happened, type : " + e.getClass(), e);
        }
        this.sleep();
        try {
            SymConfig config = this.botClient.getConfig();
            if (config instanceof SymLoadBalancedConfig) {
                ((SymLoadBalancedConfig)config).rotateAgent();
            }
            this.datafeedId = this.datafeedClient.createDatafeed();
            this.resetTimeout();
        }
        catch (Exception e1) {
            this.sleep();
            this.handleError(e);
        }
    }

    private void sleep() {
        try {
            this.logger.info("Sleeping for {} seconds before retrying..", (Object)TIMEOUT_NO_OF_SECS);
            TimeUnit.SECONDS.sleep(TIMEOUT_NO_OF_SECS);
            TIMEOUT_NO_OF_SECS = TIMEOUT_NO_OF_SECS * 2 <= 300 ? (TIMEOUT_NO_OF_SECS *= 2) : 300;
        }
        catch (InterruptedException ie) {
            this.logger.error("Error trying to sleep ", (Throwable)ie);
        }
    }
}

