/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import exceptions.APIClientErrorException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import model.DatafeedEvent;
import model.datafeed.DatafeedV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.AbstractDatafeedEventsService;
import services.Sleeper;

class DatafeedEventsServiceV2
extends AbstractDatafeedEventsService {
    private static final Logger logger = LoggerFactory.getLogger(DatafeedEventsServiceV2.class);
    private static final int AWAIT_TERMINATION = 1000;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ExecutorService threadPool;
    private final Sleeper sleeper;

    public DatafeedEventsServiceV2(SymBotClient client) {
        super(client);
        this.sleeper = new Sleeper();
        this.readDatafeed();
    }

    DatafeedEventsServiceV2(SymBotClient client, Sleeper sleeper) {
        super(client);
        this.sleeper = sleeper;
        this.readDatafeed();
    }

    @Override
    public void readDatafeed() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        this.threadPool = Executors.newSingleThreadExecutor();
        this.started.set(true);
        this.threadPool.submit(() -> {
            do {
                try {
                    this.readEventsFromDatafeed();
                }
                catch (APIClientErrorException e) {
                    logger.debug("Something went wrong rather than faulty datafeed", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Something went wrong while reading datafeed", (Throwable)e);
                    logger.info("Sleeping for {} seconds before retrying..", (Object)this.botClient.getConfig().getDatafeedEventsErrorTimeout());
                    this.sleeper.sleep(this.botClient.getConfig().getDatafeedEventsErrorTimeout());
                }
            } while (this.started.get());
        });
    }

    private void readEventsFromDatafeed() {
        List<DatafeedV2> datafeedIds = this.datafeedClient.listDatafeedId();
        String datafeedId = datafeedIds.isEmpty() ? this.createDatafeedId() : datafeedIds.get(0).getId();
        logger.info("Start reading datafeed events from datafeed {}", (Object)datafeedId);
        do {
            try {
                List<DatafeedEvent> events = this.datafeedClient.readDatafeed(datafeedId, this.datafeedClient.getAckId());
                if (events == null || events.isEmpty()) continue;
                this.handleEvents(events);
            }
            catch (APIClientErrorException e) {
                logger.debug("Something went wrong with this datafeed: {}", (Object)datafeedId, (Object)e);
                logger.info(e.getMessage());
                this.datafeedClient.deleteDatafeed(datafeedId);
                break;
            }
        } while (this.started.get());
    }

    @Override
    public void stopDatafeedService() {
        block6: {
            this.started.set(false);
            if (this.threadPool == null) break block6;
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    this.threadPool.shutdownNow();
                    if (!this.threadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void restartDatafeedService() {
        this.started.set(false);
        this.readDatafeed();
    }

    private String createDatafeedId() {
        String datafeedId = null;
        do {
            try {
                datafeedId = this.datafeedClient.createDatafeed();
            }
            catch (Exception e) {
                logger.error("Unable to create feedId ({}), will retry in {} seconds.", (Object)e.getMessage(), (Object)this.botClient.getConfig().getDatafeedEventsErrorTimeout());
                logger.trace("More details :", (Throwable)e);
                this.sleeper.sleep(this.botClient.getConfig().getDatafeedEventsErrorTimeout());
            }
        } while (datafeedId == null);
        return datafeedId;
    }
}

