/*
 * Decompiled with CFR 0.152.
 */
package utils;

import configuration.SymConfig;
import internal.FileHelper;
import internal.jersey.NoCacheFeature;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilderHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientBuilderHelper.class);
    private static final String TRUSTSTORE_FORMAT = "JKS";

    public static ClientBuilder getHttpClientBuilderWithTruststore(SymConfig config) {
        return ((ClientBuilder)ClientBuilder.newBuilder().register(NoCacheFeature.class)).sslContext(HttpClientBuilderHelper.createSSLContext(config.getTruststorePath(), config.getTruststorePassword(), null, null));
    }

    public static ClientBuilder getHttpClientBotBuilder(SymConfig config) {
        return ((ClientBuilder)ClientBuilder.newBuilder().register(NoCacheFeature.class)).sslContext(HttpClientBuilderHelper.createSSLContext(config.getTruststorePath(), config.getTruststorePassword(), FileHelper.path(config.getBotCertPath(), config.getBotCertName()), config.getBotCertPassword()));
    }

    public static ClientBuilder getHttpClientAppBuilder(SymConfig config) {
        return ((ClientBuilder)ClientBuilder.newBuilder().register(NoCacheFeature.class)).sslContext(HttpClientBuilderHelper.createSSLContext(config.getTruststorePath(), config.getTruststorePassword(), FileHelper.path(config.getAppCertPath(), config.getAppCertName()), config.getAppCertPassword()));
    }

    public static ClientConfig getPodClientConfig(SymConfig config) {
        return HttpClientBuilderHelper.getClientConfig(config, HttpClientBuilderHelper.getOr(config.getPodProxyURL(), config.getProxyURL()), HttpClientBuilderHelper.getOr(config.getPodProxyUsername(), config.getProxyUsername()), HttpClientBuilderHelper.getOr(config.getPodProxyPassword(), config.getProxyPassword()));
    }

    public static ClientConfig getAgentClientConfig(SymConfig config) {
        return HttpClientBuilderHelper.getClientConfig(config, HttpClientBuilderHelper.getOr(config.getAgentProxyURL(), config.getProxyURL()), HttpClientBuilderHelper.getOr(config.getAgentProxyUsername(), config.getProxyUsername()), HttpClientBuilderHelper.getOr(config.getAgentProxyPassword(), config.getProxyPassword()));
    }

    public static ClientConfig getKMClientConfig(SymConfig config) {
        return HttpClientBuilderHelper.getClientConfig(config, HttpClientBuilderHelper.getOr(config.getKeyManagerProxyURL(), config.getProxyURL()), HttpClientBuilderHelper.getOr(config.getKeyManagerProxyUsername(), config.getProxyUsername()), HttpClientBuilderHelper.getOr(config.getKeyManagerProxyPassword(), config.getProxyPassword()));
    }

    private static ClientConfig getClientConfig(SymConfig config, String proxyURL, String proxyUser, String proxyPass) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)config.getConnectionTimeout());
        clientConfig.property("jersey.config.client.readTimeout", (Object)config.getReadTimeout());
        if (!StringUtils.isEmpty((CharSequence)proxyURL)) {
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
            if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
                clientConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
            }
        }
        return clientConfig;
    }

    protected static SSLContext createSSLContext(@Nullable String truststorePath, @Nullable String truststorePassword, @Nullable String keystorePath, @Nullable String keystorePassword) {
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        if (!StringUtils.isEmpty((CharSequence)truststorePath) && !StringUtils.isEmpty((CharSequence)truststorePassword)) {
            byte[] trustStoreBytes = FileHelper.readFile(truststorePath);
            KeyStore truststore = KeyStore.getInstance(TRUSTSTORE_FORMAT);
            truststore.load(new ByteArrayInputStream(trustStoreBytes), truststorePassword.toCharArray());
            HttpClientBuilderHelper.addDefaultRootCaCertificates(truststore);
            if (logger.isDebugEnabled()) {
                ArrayList<String> aliases = Collections.list(truststore.aliases());
                logger.debug("Your custom truststore ('{}') contains {} entries :", (Object)truststorePath, (Object)aliases.size());
                for (String alias : aliases) {
                    logger.debug("# {}", (Object)alias);
                }
            }
            sslConfig.trustStore(truststore);
        }
        if (!StringUtils.isEmpty((CharSequence)keystorePath) && !StringUtils.isEmpty((CharSequence)keystorePassword)) {
            byte[] keystoreBytes = FileHelper.readFile(keystorePath);
            sslConfig.keyStoreBytes(keystoreBytes).keyStorePassword(keystorePassword);
        }
        return sslConfig.createSSLContext();
    }

    private static String getOr(String preferredValue, String fallbackValue) {
        return !StringUtils.isEmpty((CharSequence)preferredValue) ? preferredValue : fallbackValue;
    }

    private static void addDefaultRootCaCertificates(KeyStore trustStore) throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate acceptedIssuer : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                trustStore.setCertificateEntry(acceptedIssuer.getSubjectDN().getName(), acceptedIssuer);
            }
        }
    }
}

