/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Pattern;
import model.UserInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.LoggerFactory;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import utils.CertificateUtils;

public class JwtHelper {
    private static final String PKCS_1_REGEX_STRING = "-{5}BEGIN RSA PRIVATE KEY-{5}.*-{5}END RSA PRIVATE KEY-{5}";
    private static final String PKCS_8_REGEX_STRING = "-{5}BEGIN PRIVATE KEY-{5}.*-{5}END PRIVATE KEY-{5}";
    private static final Pattern PKCS_1_REGEX = Pattern.compile("-{5}BEGIN RSA PRIVATE KEY-{5}.*-{5}END RSA PRIVATE KEY-{5}", 32);
    private static final Pattern PKCS_8_REGEX = Pattern.compile("-{5}BEGIN PRIVATE KEY-{5}.*-{5}END PRIVATE KEY-{5}", 32);
    private static final String PKCS_PADDING_REGEX = "[\\r\\n]?-{5}(BEGIN|END) (RSA )?PRIVATE KEY-{5}[\\r\\n]?";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String createSignedJwt(String user, long expiration, Key privateKey) {
        return Jwts.builder().setSubject(user).setExpiration(new Date(System.currentTimeMillis() + expiration)).signWith(SignatureAlgorithm.RS512, privateKey).compact();
    }

    public static PrivateKey parseRSAPrivateKey(File pemPrivateKeyFile) throws IOException, GeneralSecurityException {
        return JwtHelper.parseRSAPrivateKey(FileUtils.readFileToString((File)pemPrivateKeyFile, (Charset)Charset.defaultCharset()));
    }

    public static PrivateKey parseRSAPrivateKey(InputStream pemPrivateKeyFile) throws IOException, GeneralSecurityException {
        return JwtHelper.parseRSAPrivateKey(IOUtils.toString((InputStream)pemPrivateKeyFile, (Charset)Charset.defaultCharset()));
    }

    public static PrivateKey parseRSAPrivateKey(byte[] content) throws IOException, GeneralSecurityException {
        return JwtHelper.parseRSAPrivateKey(IOUtils.toString((byte[])content, (String)"utf-8"));
    }

    private static PrivateKey parseRSAPrivateKey(String pemPrivateKey) throws GeneralSecurityException {
        pemPrivateKey = pemPrivateKey.trim();
        boolean isPkcs1 = PKCS_1_REGEX.matcher(pemPrivateKey).matches();
        boolean isPkcs8 = PKCS_8_REGEX.matcher(pemPrivateKey).matches();
        if (!isPkcs1 && !isPkcs8) {
            throw new GeneralSecurityException("Invalid private key.");
        }
        pemPrivateKey = pemPrivateKey.replaceAll(PKCS_PADDING_REGEX, "").replaceAll("\\n", "\n").replaceAll("\\s", "");
        byte[] pemPrivateKeyBytes = Base64.getDecoder().decode(pemPrivateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        if (isPkcs8) {
            try {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pemPrivateKeyBytes);
                return keyFactory.generatePrivate(spec);
            }
            catch (InvalidKeySpecException e) {
                throw new GeneralSecurityException("Invalid PKCS#8 private key.");
            }
        }
        try {
            DerInputStream derReader = new DerInputStream(pemPrivateKeyBytes);
            DerValue[] seq = derReader.getSequence(0);
            BigInteger modulus = seq[1].getBigInteger();
            BigInteger publicExp = seq[2].getBigInteger();
            BigInteger privateExp = seq[3].getBigInteger();
            BigInteger prime1 = seq[4].getBigInteger();
            BigInteger prime2 = seq[5].getBigInteger();
            BigInteger exp1 = seq[6].getBigInteger();
            BigInteger exp2 = seq[7].getBigInteger();
            BigInteger crtCoefficient = seq[8].getBigInteger();
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoefficient);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Invalid PKCS#1 private key.");
        }
    }

    public static UserInfo validateJwt(String jwt, String certificate) {
        try {
            PublicKey publicKey = CertificateUtils.parseX509Certificate(certificate).getPublicKey();
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).setSkipAllValidators().build();
            JwtClaims jwtDecoded = jwtConsumer.processToClaims(jwt);
            Object userInfoObject = jwtDecoded.getClaimValue("user");
            return (UserInfo)objectMapper.readValue(objectMapper.writeValueAsString(userInfoObject), UserInfo.class);
        }
        catch (IOException | GeneralSecurityException | InvalidJwtException e) {
            LoggerFactory.getLogger(JwtHelper.class).error("Error with decoding jwt", e);
            return null;
        }
    }
}

