/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.simple;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SplitParagraphBlocksFilter
implements BoilerpipeFilter {
    public static final SplitParagraphBlocksFilter INSTANCE = new SplitParagraphBlocksFilter();

    public static SplitParagraphBlocksFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        List<TextBlock> blocks = doc.getTextBlocks();
        ArrayList<TextBlock> blocksNew = new ArrayList<TextBlock>();
        for (TextBlock tb : blocks) {
            String text = tb.getText();
            String[] paragraphs = text.split("[\n\r]+");
            if (paragraphs.length < 2) {
                blocksNew.add(tb);
                continue;
            }
            boolean isContent = tb.isContent();
            Set<String> labels = tb.getLabels();
            String[] stringArray = paragraphs;
            int n = paragraphs.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                TextBlock tbP = new TextBlock(p);
                tbP.setIsContent(isContent);
                tbP.addLabels(labels);
                blocksNew.add(tbP);
                changes = true;
                ++n2;
            }
        }
        if (changes) {
            blocks.clear();
            blocks.addAll(blocksNew);
        }
        return changes;
    }
}

