/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.Image;
import de.l3s.boilerpipe.document.Media;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.document.VimeoVideo;
import de.l3s.boilerpipe.document.YoutubeVideo;
import de.l3s.boilerpipe.sax.BoilerpipeSAXInput;
import de.l3s.boilerpipe.sax.HTMLDocument;
import de.l3s.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class MediaExtractor {
    public static final MediaExtractor INSTANCE = new MediaExtractor();
    private static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        @Override
        void beforeStart(Implementation instance, String localName) {
            Implementation implementation = instance;
            implementation.inIgnorableElement = implementation.inIgnorableElement + 1;
        }

        @Override
        void afterEnd(Implementation instance, String localName) {
            Implementation implementation = instance;
            implementation.inIgnorableElement = implementation.inIgnorableElement - 1;
        }
    };
    private static Map<String, TagAction> TAG_ACTIONS = new HashMap<String, TagAction>();

    static {
        TAG_ACTIONS.put("STYLE", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("SCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OPTION", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("NOSCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("EMBED", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("APPLET", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("LINK", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("HEAD", TA_IGNORABLE_ELEMENT);
    }

    public static MediaExtractor getInstance() {
        return INSTANCE;
    }

    public List<Media> process(TextDocument doc, String origHTML) throws BoilerpipeProcessingException {
        return this.process(doc, new InputSource(new StringReader(origHTML)));
    }

    public List<Media> process(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
        Implementation implementation = new Implementation();
        implementation.process(doc, is);
        return implementation.linksHighlight;
    }

    public List<Media> process(URL url, BoilerpipeExtractor extractor) throws IOException, BoilerpipeProcessingException, SAXException {
        HTMLDocument htmlDoc = HTMLFetcher.fetch(url);
        TextDocument doc = new BoilerpipeSAXInput(htmlDoc.toInputSource()).getTextDocument();
        extractor.process(doc);
        InputSource is = htmlDoc.toInputSource();
        return this.process(doc, is);
    }

    public List<Media> process(String doc, BoilerpipeExtractor extractor) {
        HTMLDocument htmlDoc = new HTMLDocument(doc);
        ArrayList<Media> media = new ArrayList();
        try {
            TextDocument tdoc = new BoilerpipeSAXInput(htmlDoc.toInputSource()).getTextDocument();
            extractor.process(tdoc);
            InputSource is = htmlDoc.toInputSource();
            media = this.process(tdoc, is);
        }
        catch (Exception e) {
            return null;
        }
        return media;
    }

    private final class Implementation
    extends AbstractSAXParser
    implements ContentHandler {
        List<Media> linksHighlight;
        private List<Media> linksBuffer;
        private int inIgnorableElement;
        private int characterElementIdx;
        private final BitSet contentBitSet;
        private boolean inHighlight;

        Implementation() {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.linksHighlight = new ArrayList<Media>();
            this.linksBuffer = new ArrayList<Media>();
            this.inIgnorableElement = 0;
            this.characterElementIdx = 0;
            this.contentBitSet = new BitSet();
            this.inHighlight = false;
            this.setContentHandler(this);
        }

        void process(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
            for (TextBlock block : doc.getTextBlocks()) {
                BitSet bs;
                if (!block.isContent() || (bs = block.getContainedTextElements()) == null) continue;
                this.contentBitSet.or(bs);
            }
            try {
                this.parse(is);
            }
            catch (SAXException e) {
                throw new BoilerpipeProcessingException(e);
            }
            catch (IOException e) {
                throw new BoilerpipeProcessingException(e);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block16: {
                TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
                if (ta != null) {
                    ta.beforeStart(this, localName);
                }
                try {
                    String src;
                    if (this.inIgnorableElement != 0) break block16;
                    if (this.inHighlight && "IFRAME".equalsIgnoreCase(localName)) {
                        String[] pathParts;
                        String path;
                        URL url2;
                        String originUrl;
                        src = atts.getValue("src");
                        if (src != null) {
                            src = src.replaceAll("\\\\\"", "");
                        }
                        if (src != null && src.length() > 0 && src.contains("youtube.com/embed/")) {
                            originUrl = null;
                            try {
                                url2 = new URL(src);
                                path = url2.getPath();
                                pathParts = path.split("/");
                                originUrl = "http://www.youtube.com/watch?v=" + pathParts[pathParts.length - 1];
                                this.linksBuffer.add(new YoutubeVideo(originUrl, src));
                            }
                            catch (MalformedURLException url2) {
                                // empty catch block
                            }
                        }
                        if (src != null && src.length() > 0 && src.contains("player.vimeo.com")) {
                            originUrl = null;
                            try {
                                url2 = new URL(src);
                                path = url2.getPath();
                                pathParts = path.split("/");
                                originUrl = "http://vimeo.com/" + pathParts[pathParts.length - 1];
                                this.linksBuffer.add(new VimeoVideo(originUrl, src));
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!this.inHighlight || !"IMG".equalsIgnoreCase(localName)) break block16;
                    src = atts.getValue("src");
                    try {
                        URI image = new URI(src);
                        if (src != null && src.length() > 0) {
                            this.linksBuffer.add(new Image(src, atts.getValue("width"), atts.getValue("height"), atts.getValue("alt")));
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                finally {
                    if (ta != null) {
                        ta.afterStart(this, localName);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
            if (ta != null) {
                ta.beforeEnd(this, localName);
            }
            if (ta != null) {
                ta.afterEnd(this, localName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ++this.characterElementIdx;
            if (this.inIgnorableElement == 0) {
                boolean highlight = this.contentBitSet.get(this.characterElementIdx);
                if (!highlight) {
                    if (length == 0) {
                        return;
                    }
                    boolean justWhitespace = true;
                    int i = start;
                    while (i < start + length) {
                        if (!Character.isWhitespace(ch[i])) {
                            justWhitespace = false;
                            break;
                        }
                        ++i;
                    }
                    if (justWhitespace) {
                        return;
                    }
                }
                this.inHighlight = highlight;
                if (this.inHighlight) {
                    this.linksHighlight.addAll(this.linksBuffer);
                    this.linksBuffer.clear();
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    private static abstract class TagAction {
        private TagAction() {
        }

        void beforeStart(Implementation instance, String localName) {
        }

        void afterStart(Implementation instance, String localName) {
        }

        void beforeEnd(Implementation instance, String localName) {
        }

        void afterEnd(Implementation instance, String localName) {
        }
    }
}

