/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public class TerminatingBlocksFinder
implements BoilerpipeFilter {
    public static final TerminatingBlocksFinder INSTANCE = new TerminatingBlocksFinder();

    public static TerminatingBlocksFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            int numWords = tb.getNumWords();
            if (numWords >= 15) continue;
            String text = tb.getText().trim();
            int len = text.length();
            if (len >= 8) {
                String textLC = text.toLowerCase();
                if (!textLC.startsWith("comments") && !TerminatingBlocksFinder.startsWithNumber(textLC, len, " comments", " users responded in") && !textLC.startsWith("\ufffd\ufffd reuters") && !textLC.startsWith("please rate this") && !textLC.startsWith("post a comment") && !textLC.contains("what you think...") && !textLC.contains("add your comment") && !textLC.contains("add comment") && !textLC.contains("reader views") && !textLC.contains("have your say") && !textLC.contains("reader comments") && !textLC.contains("r\ufffd\ufffdtta artikeln") && !textLC.contains("R\u00e9agir") && !textLC.contains("Vos r\u00e9actions ") && !textLC.equals("thanks for your comments - this feedback is now closed")) continue;
                tb.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
                changes = true;
                continue;
            }
            if ((double)tb.getLinkDensity() != 1.0 || !text.equals("Comment")) continue;
            tb.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
        }
        return changes;
    }

    private static boolean startsWithNumber(String t, int len, String ... str) {
        int j;
        for (j = 0; j < len && TerminatingBlocksFinder.isDigit(t.charAt(j)); ++j) {
        }
        if (j != 0) {
            for (String s : str) {
                if (!t.startsWith(s, j)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

