/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.synopsys.integration.bdio.BdioNodeFactory;
import com.synopsys.integration.bdio.BdioPropertyHelper;
import com.synopsys.integration.bdio.BdioWriter;
import com.synopsys.integration.bdio.graph.DependencyGraphTransformer;
import com.synopsys.integration.bdio.graph.ProjectDependencyGraph;
import com.synopsys.integration.bdio.model.BdioBillOfMaterials;
import com.synopsys.integration.bdio.model.BdioComponent;
import com.synopsys.integration.bdio.model.BdioId;
import com.synopsys.integration.bdio.model.BdioNode;
import com.synopsys.integration.bdio.model.BdioProject;
import com.synopsys.integration.bdio.model.SimpleBdioDocument;
import com.synopsys.integration.bdio.model.dependency.DependencyFactory;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import com.synopsys.integration.bdio.model.externalid.ExternalIdFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SimpleBdioFactory {
    private final BdioPropertyHelper bdioPropertyHelper;
    private final BdioNodeFactory bdioNodeFactory;
    private final DependencyGraphTransformer dependencyGraphTransformer;
    private final ExternalIdFactory externalIdFactory;
    private final DependencyFactory dependencyFactory;
    private final Gson gson;

    public SimpleBdioFactory() {
        this.bdioPropertyHelper = new BdioPropertyHelper();
        this.bdioNodeFactory = new BdioNodeFactory(this.bdioPropertyHelper);
        this.dependencyGraphTransformer = new DependencyGraphTransformer(this.bdioPropertyHelper, this.bdioNodeFactory);
        this.externalIdFactory = new ExternalIdFactory();
        this.dependencyFactory = new DependencyFactory(this.externalIdFactory);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public SimpleBdioFactory(BdioPropertyHelper bdioPropertyHelper, BdioNodeFactory bdioNodeFactory, DependencyGraphTransformer dependencyGraphTransformer, ExternalIdFactory externalIdFactory, DependencyFactory dependencyFactory, Gson gson) {
        this.bdioPropertyHelper = bdioPropertyHelper;
        this.bdioNodeFactory = bdioNodeFactory;
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        this.externalIdFactory = externalIdFactory;
        this.dependencyFactory = dependencyFactory;
        this.gson = gson;
    }

    public BdioWriter createBdioWriter(Writer writer) throws IOException {
        return new BdioWriter(this.gson, writer);
    }

    public BdioWriter createBdioWriter(OutputStream outputStream) throws IOException {
        return new BdioWriter(this.gson, outputStream);
    }

    public void writeSimpleBdioDocument(BdioWriter bdioWriter, SimpleBdioDocument simpleBdioDocument) {
        bdioWriter.writeSimpleBdioDocument(simpleBdioDocument);
    }

    public void writeSimpleBdioDocumentToFile(File bdioFile, SimpleBdioDocument simpleBdioDocument) throws IOException {
        try (BdioWriter bdioWriter = this.createBdioWriter(new FileOutputStream(bdioFile));){
            this.writeSimpleBdioDocument(bdioWriter, simpleBdioDocument);
        }
    }

    public SimpleBdioDocument createPopulatedBdioDocument(ProjectDependencyGraph projectDependencyGraph) {
        return this.createPopulatedBdioDocument(null, projectDependencyGraph);
    }

    public SimpleBdioDocument createPopulatedBdioDocument(@Nullable String codeLocationName, ProjectDependencyGraph projectDependencyGraph) {
        SimpleBdioDocument simpleBdioDocument = this.createEmptyBdioDocument(codeLocationName, projectDependencyGraph.getProjectDependency().getExternalId());
        this.populateComponents(simpleBdioDocument, projectDependencyGraph);
        return simpleBdioDocument;
    }

    public SimpleBdioDocument createEmptyBdioDocument(@Nullable String codeLocationName, ExternalId projectExternalId) {
        BdioId projectId = projectExternalId.createBdioId();
        BdioProject project = this.bdioNodeFactory.createProject(projectExternalId.getName(), projectExternalId.getVersion(), projectId);
        project.bdioExternalIdentifier = this.bdioPropertyHelper.createExternalIdentifier(projectExternalId);
        return this.createEmptyBdioDocument(codeLocationName, project);
    }

    public SimpleBdioDocument createEmptyBdioDocument(@Nullable String codeLocationName, String projectName, String projectVersionName) {
        BdioProject project = this.bdioNodeFactory.createProject(projectName, projectVersionName);
        return this.createEmptyBdioDocument(codeLocationName, project);
    }

    public SimpleBdioDocument createEmptyBdioDocument(@Nullable String codeLocationName, BdioProject project) {
        BdioBillOfMaterials billOfMaterials = this.bdioNodeFactory.createBillOfMaterials(codeLocationName, project.name, project.version);
        SimpleBdioDocument simpleBdioDocument = new SimpleBdioDocument();
        simpleBdioDocument.setBillOfMaterials(billOfMaterials);
        simpleBdioDocument.setProject(project);
        return simpleBdioDocument;
    }

    public void populateComponents(SimpleBdioDocument simpleBdioDocument, ProjectDependencyGraph projectDependencyGraph) {
        HashMap<ExternalId, BdioNode> existingComponents = new HashMap<ExternalId, BdioNode>();
        existingComponents.put(projectDependencyGraph.getProjectDependency().getExternalId(), simpleBdioDocument.getProject());
        List<BdioComponent> bdioComponents = this.dependencyGraphTransformer.transformDependencyGraph(projectDependencyGraph, simpleBdioDocument.getProject(), projectDependencyGraph.getDirectDependencies(), existingComponents);
        simpleBdioDocument.setComponents(bdioComponents);
    }

    public BdioPropertyHelper getBdioPropertyHelper() {
        return this.bdioPropertyHelper;
    }

    public BdioNodeFactory getBdioNodeFactory() {
        return this.bdioNodeFactory;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public ExternalIdFactory getExternalIdFactory() {
        return this.externalIdFactory;
    }

    public DependencyFactory getDependencyFactory() {
        return this.dependencyFactory;
    }
}

