/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.graph;

import com.synopsys.integration.bdio.graph.DependencyGraph;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class DependencyGraphUtil {
    private DependencyGraphUtil() {
    }

    public static void copyDirectDependencies(DependencyGraph destinationGraph, DependencyGraph sourceGraph) {
        DependencyGraphUtil.copyDependencies(destinationGraph, sourceGraph, sourceGraph::getDirectDependencies);
    }

    public static void copyDirectDependenciesToParent(DependencyGraph destinationGraph, Dependency parent, DependencyGraph sourceGraph) {
        DependencyGraphUtil.copyDependenciesToParent(destinationGraph, parent, sourceGraph, sourceGraph::getDirectDependencies);
    }

    public static void copyRootDependencies(DependencyGraph destinationGraph, DependencyGraph sourceGraph) {
        DependencyGraphUtil.copyDependencies(destinationGraph, sourceGraph, sourceGraph::getRootDependencies);
    }

    public static void copyRootDependenciesToParent(DependencyGraph destinationGraph, Dependency parent, DependencyGraph sourceGraph) {
        DependencyGraphUtil.copyDependenciesToParent(destinationGraph, parent, sourceGraph, sourceGraph::getRootDependencies);
    }

    public static void copyDependencies(DependencyGraph destinationGraph, DependencyGraph sourceGraph, Supplier<Set<Dependency>> dependencies) {
        HashSet<Dependency> encountered = new HashSet<Dependency>();
        for (Dependency dependency : dependencies.get()) {
            destinationGraph.addDirectDependency(dependency);
            DependencyGraphUtil.copyDependencyTreeFromGraph(destinationGraph, dependency, sourceGraph, encountered);
        }
    }

    public static void copyDependenciesToParent(DependencyGraph destinationGraph, Dependency parent, DependencyGraph sourceGraph, Supplier<Set<Dependency>> dependencies) {
        HashSet<Dependency> encountered = new HashSet<Dependency>();
        for (Dependency dependency : dependencies.get()) {
            destinationGraph.addChildWithParent(dependency, parent);
            DependencyGraphUtil.copyDependencyTreeFromGraph(destinationGraph, dependency, sourceGraph, encountered);
        }
    }

    private static void copyDependencyTreeFromGraph(DependencyGraph destinationGraph, Dependency parentDependency, DependencyGraph sourceGraph, Set<Dependency> encountered) {
        for (Dependency dependency : sourceGraph.getChildrenForParent(parentDependency)) {
            if (!encountered.contains((Object)dependency)) {
                encountered.add(dependency);
                DependencyGraphUtil.copyDependencyTreeFromGraph(destinationGraph, dependency, sourceGraph, encountered);
            }
            destinationGraph.addChildWithParent(dependency, parentDependency);
        }
    }
}

