/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio.model.dependency;

import com.synopsys.integration.bdio.model.Forge;
import com.synopsys.integration.bdio.model.dependency.Dependency;
import com.synopsys.integration.bdio.model.externalid.ExternalId;
import com.synopsys.integration.bdio.model.externalid.ExternalIdFactory;

public class DependencyFactory {
    private final ExternalIdFactory externalIdFactory;

    public DependencyFactory() {
        this(ExternalId.FACTORY);
    }

    public DependencyFactory(ExternalIdFactory externalIdFactory) {
        this.externalIdFactory = externalIdFactory;
    }

    public Dependency createPathDependency(Forge forge, String path) {
        return new Dependency(this.externalIdFactory.createPathExternalId(forge, path));
    }

    public Dependency createModuleNamesDependency(Forge forge, String ... moduleNames) {
        return new Dependency(this.externalIdFactory.createModuleNamesExternalId(forge, moduleNames));
    }

    public Dependency createNameVersionDependency(Forge forge, String name, String version) {
        return new Dependency(name, version, this.externalIdFactory.createNameVersionExternalId(forge, name, version));
    }

    public Dependency createNameVersionDependency(Forge forge, String name) {
        return this.createNameVersionDependency(forge, name, null);
    }

    public Dependency createYoctoDependency(String layer, String name, String version) {
        return new Dependency(this.externalIdFactory.createYoctoExternalId(layer, name, version));
    }

    public Dependency createYoctoDependency(String layer, String name) {
        return this.createYoctoDependency(layer, name, null);
    }

    public Dependency createMavenDependency(String group, String name, String version) {
        return new Dependency(this.externalIdFactory.createMavenExternalId(group, name, version));
    }

    public Dependency createMavenDependency(String group, String name) {
        return this.createMavenDependency(group, name, null);
    }

    public Dependency createArchitectureDependency(Forge forge, String name, String version, String architecture) {
        return new Dependency(this.externalIdFactory.createArchitectureExternalId(forge, name, version, architecture));
    }

    public Dependency createArchitectureDependency(Forge forge, String name, String architecture) {
        return this.createArchitectureDependency(forge, name, null, architecture);
    }
}

