/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.client;

import java.util.Optional;

public class ConnectionResult {
    private final int httpStatusCode;
    private final String failureMessage;
    private final Exception exception;

    public static final ConnectionResult SUCCESS(int httpStatusCode) {
        return new ConnectionResult(httpStatusCode, null, null);
    }

    public static final ConnectionResult FAILURE(int httpStatusCode, String failureMessage, Exception exception) {
        return new ConnectionResult(httpStatusCode, failureMessage, exception);
    }

    public ConnectionResult(int httpStatusCode, String failureMessage, Exception exception) {
        this.httpStatusCode = httpStatusCode;
        this.failureMessage = failureMessage;
        this.exception = exception;
    }

    public boolean isSuccess() {
        return !this.isFailure();
    }

    public boolean isFailure() {
        return this.getFailureMessage().isPresent();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Optional<String> getFailureMessage() {
        return Optional.ofNullable(this.failureMessage);
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }
}

