/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.request;

import com.synopsys.integration.builder.Buildable;
import com.synopsys.integration.builder.BuilderStatus;
import com.synopsys.integration.builder.IntegrationBuilder;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.body.BodyContent;
import com.synopsys.integration.util.Stringable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Request
extends Stringable
implements Buildable {
    private final HttpUrl url;
    private final HttpMethod method;
    private final Charset bodyEncoding;
    private final Map<String, Set<String>> queryParameters = new HashMap<String, Set<String>>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final BodyContent bodyContent;

    public Request(HttpUrl url, HttpMethod method, Charset bodyEncoding, Map<String, Set<String>> queryParameters, Map<String, String> headers, BodyContent bodyContent) {
        this.url = url;
        this.method = method;
        this.bodyEncoding = null == bodyEncoding ? StandardCharsets.UTF_8 : bodyEncoding;
        this.queryParameters.putAll(queryParameters);
        this.headers.putAll(headers);
        this.bodyContent = bodyContent;
    }

    public Request(Builder builder) {
        this(builder.url, builder.method, builder.bodyEncoding, builder.queryParameters, builder.headers, builder.bodyContent);
    }

    public Builder createBuilder() {
        return new Builder(this);
    }

    public HttpUrl getUrl() {
        return this.url;
    }

    public Map<String, Set<String>> getPopulatedQueryParameters() {
        return new HashMap<String, Set<String>>(this.queryParameters);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Charset getBodyEncoding() {
        return this.bodyEncoding;
    }

    public Map<String, Set<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public static class Builder
    extends IntegrationBuilder<Request> {
        private HttpUrl url;
        private HttpMethod method;
        private Charset bodyEncoding;
        private Map<String, Set<String>> queryParameters = new HashMap<String, Set<String>>();
        private Map<String, String> headers = new HashMap<String, String>();
        private BodyContent bodyContent;

        public Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.bodyEncoding = request.bodyEncoding;
            this.queryParameters.putAll(request.queryParameters);
            this.headers.putAll(request.headers);
            this.bodyContent = request.bodyContent;
        }

        public Builder(Builder builder) {
            this.url = builder.url;
            this.method = builder.method;
            this.bodyEncoding = builder.bodyEncoding;
            this.queryParameters.putAll(builder.queryParameters);
            this.headers.putAll(builder.headers);
            this.bodyContent = builder.bodyContent;
        }

        public Builder() {
            this(null, HttpMethod.GET);
        }

        public Builder(HttpUrl url) {
            this(url, HttpMethod.GET);
        }

        public Builder(HttpUrl url, HttpMethod method) {
            this(url, method, new HashMap<String, String>());
        }

        public Builder(HttpUrl url, HttpMethod method, Map<String, String> headers) {
            this.url = url;
            this.method = method;
            this.headers.putAll(headers);
            this.bodyEncoding = StandardCharsets.UTF_8;
        }

        protected Request buildWithoutValidation() {
            return new Request(this.getUrl(), this.getMethod(), this.getBodyEncoding(), this.getQueryParameters(), this.getHeaders(), this.getBodyContent());
        }

        protected void validate(BuilderStatus builderStatus) {
        }

        public Builder url(HttpUrl url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder bodyEncoding(Charset bodyEncoding) {
            this.bodyEncoding = bodyEncoding;
            return this;
        }

        public Builder queryParameters(Map<String, Set<String>> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder addQueryParameter(String key, String value) {
            this.queryParameters.computeIfAbsent(key, k -> new HashSet()).add(value);
            return this;
        }

        public Builder setQueryParameter(String key, String value) {
            this.queryParameters.put(key, new HashSet<String>(Arrays.asList(value)));
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder bodyContent(BodyContent bodyContent) {
            this.bodyContent = bodyContent;
            return this;
        }

        public HttpUrl getUrl() {
            return this.url;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Charset getBodyEncoding() {
            return this.bodyEncoding;
        }

        public Map<String, Set<String>> getQueryParameters() {
            return this.queryParameters;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public BodyContent getBodyContent() {
            return this.bodyContent;
        }
    }
}

