/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.response;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.impl.client.CloseableHttpClient;

public class DefaultResponse
implements Response {
    private final HttpUriRequest request;
    private final CloseableHttpClient client;
    private final CloseableHttpResponse response;

    public DefaultResponse(HttpUriRequest request, CloseableHttpClient client, CloseableHttpResponse response) {
        this.request = request;
        this.client = client;
        this.response = response;
    }

    @Override
    public HttpUriRequest getRequest() {
        return this.request;
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public boolean isStatusCodeSuccess() {
        return this.getStatusCode() >= 200 && this.getStatusCode() < 300;
    }

    @Override
    public boolean isStatusCodeError() {
        return this.getStatusCode() >= 400;
    }

    @Override
    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public InputStream getContent() throws IntegrationException {
        if (this.response.getEntity() != null) {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new IntegrationException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getContentString() throws IntegrationException {
        return this.getContentString(StandardCharsets.UTF_8);
    }

    @Override
    public String getContentString(Charset encoding) throws IntegrationException {
        if (this.response.getEntity() != null) {
            String string;
            block9: {
                InputStream inputStream = this.response.getEntity().getContent();
                try {
                    string = IOUtils.toString((InputStream)inputStream, (Charset)encoding);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        throw new IntegrationException(e.getMessage(), (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return string;
        }
        return null;
    }

    @Override
    public Long getContentLength() {
        if (this.response.getEntity() != null) {
            return this.response.getEntity().getContentLength();
        }
        return null;
    }

    @Override
    public String getContentEncoding() {
        if (this.response.getEntity() != null && this.response.getEntity().getContentEncoding() != null) {
            return this.response.getEntity().getContentEncoding().getValue();
        }
        return null;
    }

    @Override
    public String getContentType() {
        if (this.response.getEntity() != null && this.response.getEntity().getContentType() != null) {
            return this.response.getEntity().getContentType().getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.response.getAllHeaders() != null && this.response.getAllHeaders().length > 0) {
            for (Header header : this.response.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
        }
        return headers;
    }

    @Override
    public String getHeaderValue(String name) {
        if (this.response.containsHeader(name)) {
            return this.response.getFirstHeader(name).getValue();
        }
        return null;
    }

    @Override
    public CloseableHttpResponse getActualResponse() {
        return this.response;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
        this.client.close();
    }

    @Override
    public long getLastModified() throws IntegrationException {
        String lastModified = this.getHeaderValue("Last-Modified");
        long lastModifiedLong = 0L;
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date parsed = format.parse(lastModified);
                lastModifiedLong = parsed.getTime();
            }
            catch (ParseException e) {
                throw new IntegrationException("Could not parse the last modified date : " + e.getMessage());
            }
        }
        return lastModifiedLong;
    }

    @Override
    public void throwExceptionForError() throws IntegrationRestException {
        if (this.isStatusCodeError()) {
            String httpResponseContent;
            int statusCode = this.getStatusCode();
            String statusMessage = this.getStatusMessage();
            try {
                httpResponseContent = this.getContentString();
            }
            catch (IntegrationException e) {
                httpResponseContent = e.getMessage();
            }
            String statusCodeDescription = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.ENGLISH);
            String reasonPhraseDescription = "";
            if (StringUtils.isNotBlank((CharSequence)statusMessage)) {
                reasonPhraseDescription = String.format(", reason phrase was %s", statusMessage);
            }
            String messageFormat = "There was a problem trying to %s %s, response was %s %s%s.";
            HttpMethod httpMethod = HttpMethod.fromMethod(this.request.getMethod());
            HttpUrl httpUrl = null;
            try {
                httpUrl = new HttpUrl(this.request.getURI());
            }
            catch (IntegrationException integrationException) {
                // empty catch block
            }
            String message = String.format(messageFormat, new Object[]{httpMethod, httpUrl.string(), statusCode, statusCodeDescription, reasonPhraseDescription});
            throw new IntegrationRestException(httpMethod, httpUrl, statusCode, statusMessage, httpResponseContent, message);
        }
    }
}

