/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.proxy;

import com.synopsys.integration.builder.BuilderStatus;
import com.synopsys.integration.builder.IntegrationBuilder;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import org.apache.commons.lang3.StringUtils;

public class ProxyInfoBuilder
extends IntegrationBuilder<ProxyInfo> {
    private String host;
    private int port;
    private Credentials credentials;
    private String ntlmDomain;
    private String ntlmWorkstation;

    protected ProxyInfo buildWithoutValidation() {
        if (this.isBlank()) {
            return ProxyInfo.NO_PROXY_INFO;
        }
        return new ProxyInfo(this.host, this.port, this.credentials, this.ntlmDomain, this.ntlmWorkstation);
    }

    protected void validate(BuilderStatus builderStatus) {
        ProxyInfo tempInfo = this.buildWithoutValidation();
        if (!tempInfo.isBlank()) {
            if (StringUtils.isBlank((CharSequence)this.host) || this.port <= 0) {
                builderStatus.addErrorMessage("The proxy host must be specified and the port must be greater than zero.");
            }
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.ntlmDomain, this.ntlmWorkstation}) && (null == this.credentials || this.credentials.isBlank())) {
                builderStatus.addErrorMessage("Proxy username and password must be set for the NTLM proxy.");
            }
        }
    }

    public boolean isBlank() {
        boolean isBlank = true;
        isBlank &= StringUtils.isBlank((CharSequence)this.host);
        isBlank &= this.port <= 0;
        isBlank &= null == this.credentials || this.credentials.isBlank();
        isBlank &= StringUtils.isBlank((CharSequence)this.ntlmDomain);
        return isBlank &= StringUtils.isBlank((CharSequence)this.ntlmWorkstation);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    public String getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public void setNtlmWorkstation(String ntlmWorkstation) {
        this.ntlmWorkstation = ntlmWorkstation;
    }
}

