/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.annotations;

import com.synopsys.integration.jenkins.annotations.HelpMarkdown;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;

public class HelpHtmlGenerator {
    private final Filer filer;
    private final Parser parser;
    private final HtmlRenderer renderer;

    public HelpHtmlGenerator(Filer filer) {
        this.filer = filer;
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Collections.singleton(TablesExtension.create()));
        options.set(Parser.CODE_SOFT_LINE_BREAKS, (Object)true);
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    public void generateHelpHtmlFromAnnotation(String resourcePackage, VariableElement variableElement) throws IOException {
        HelpMarkdown helpMarkdown = variableElement.getAnnotation(HelpMarkdown.class);
        if (helpMarkdown != null && StringUtils.isNotBlank((CharSequence)helpMarkdown.value())) {
            String fileName = "help-" + variableElement.getSimpleName().toString() + ".html";
            String mdContents = "<div>\r\n\r\n" + helpMarkdown.value() + "\r\n</div>";
            Document document = this.parser.parse(mdContents);
            String fileContents = this.renderer.render((Node)document);
            FileObject helpHtmlFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, resourcePackage, fileName, new Element[0]);
            try (Writer writer = helpHtmlFile.openWriter();){
                writer.write(fileContents);
            }
        }
    }
}

