/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class PasswordMaskingOutputStream
extends LineTransformationOutputStream {
    public static final String MASKED_PASSWORD = "********";
    private final OutputStream wrappedOutputStream;
    private final String passwordToMask;

    public PasswordMaskingOutputStream(OutputStream wrappedOutputStream, String passwordToMask) {
        this.wrappedOutputStream = wrappedOutputStream;
        this.passwordToMask = passwordToMask;
    }

    protected void eol(byte[] bytes, int len) throws IOException {
        String line = new String(bytes, 0, len, StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank((CharSequence)this.passwordToMask)) {
            line = line.replaceAll(this.passwordToMask, MASKED_PASSWORD);
        }
        this.wrappedOutputStream.write(line.getBytes(StandardCharsets.UTF_8));
    }
}

