/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.extensions;

import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public class JenkinsIntLogger
extends IntLogger
implements Serializable {
    private static final long serialVersionUID = -685871863395350470L;
    private final TaskListener jenkinsTaskListener;
    private LogLevel logLevel = LogLevel.INFO;

    public static JenkinsIntLogger logToListener(TaskListener jenkinsTaskListener) {
        return new JenkinsIntLogger(jenkinsTaskListener);
    }

    public static JenkinsIntLogger logToStandardOut() {
        return new JenkinsIntLogger(null);
    }

    private JenkinsIntLogger(TaskListener jenkinsTaskListener) {
        this.jenkinsTaskListener = jenkinsTaskListener;
    }

    public TaskListener getTaskListener() {
        return this.jenkinsTaskListener;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    public void alwaysLog(String txt) {
        this.printLog(txt, null);
    }

    public void debug(String txt) {
        if (this.logLevel.isLoggable(LogLevel.DEBUG)) {
            this.printLog(txt, null);
        }
    }

    public void debug(String txt, Throwable e) {
        if (this.logLevel.isLoggable(LogLevel.DEBUG)) {
            this.printLog(txt, e);
        }
    }

    public void error(Throwable e) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            this.printLog(null, e);
        }
    }

    public void error(String txt) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            this.printLog(txt, null);
        }
    }

    public void error(String txt, Throwable e) {
        if (this.logLevel.isLoggable(LogLevel.ERROR)) {
            this.printLog(txt, e);
        }
    }

    public void info(String txt) {
        if (this.logLevel.isLoggable(LogLevel.INFO)) {
            this.printLog(txt, null);
        }
    }

    public void trace(String txt) {
        if (this.logLevel.isLoggable(LogLevel.TRACE)) {
            this.printLog(txt, null);
        }
    }

    public void trace(String txt, Throwable e) {
        if (this.logLevel.isLoggable(LogLevel.TRACE)) {
            this.printLog(txt, e);
        }
    }

    public void warn(String txt) {
        if (this.logLevel.isLoggable(LogLevel.WARN)) {
            this.printLog(txt, null);
        }
    }

    private void printLog(String txt, Throwable e) {
        PrintStream logStream;
        PrintStream printStream = logStream = this.jenkinsTaskListener != null ? this.jenkinsTaskListener.getLogger() : System.out;
        if (txt != null) {
            logStream.println(txt);
        }
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logStream.println(sw.toString());
        }
    }
}

