/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.service;

import com.synopsys.integration.jenkins.extensions.ChangeBuildStatusTo;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Result;
import java.io.IOException;
import java.util.Optional;

public class JenkinsBuildService {
    private final JenkinsIntLogger logger;
    private final AbstractBuild<?, ?> build;

    public JenkinsBuildService(JenkinsIntLogger logger, AbstractBuild<?, ?> build) {
        this.logger = logger;
        this.build = build;
    }

    public void markBuildFailed(String message) {
        this.logger.error(message);
        this.build.setResult(Result.FAILURE);
    }

    public void markBuildFailed(Exception e) {
        this.logger.error(e);
        this.build.setResult(Result.FAILURE);
    }

    public void markBuildUnstable(Exception e) {
        this.logger.error(e);
        this.build.setResult(Result.UNSTABLE);
    }

    public void markBuildAs(ChangeBuildStatusTo changeBuildStatusTo) {
        Result result = changeBuildStatusTo.getResult();
        this.logger.alwaysLog("Setting build status to " + result.toString());
        this.build.setResult(result);
    }

    public Optional<String> getJDKRemoteHomeOrEmpty() throws InterruptedException {
        Optional<JDK> possibleJdk = Optional.ofNullable(this.build).map(AbstractBuild::getProject).map(AbstractProject::getJDK);
        if (possibleJdk.isPresent()) {
            try {
                JDK jdk = possibleJdk.get();
                JDK nodeJdk = jdk.forNode(this.build.getBuiltOn(), this.logger.getTaskListener());
                return Optional.ofNullable(nodeJdk.getHome());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public void markBuildAborted() {
        this.build.setResult(Result.ABORTED);
    }

    public void markBuildInterrupted() {
        Executor executor = this.build.getExecutor();
        if (executor == null) {
            this.markBuildAborted();
        } else {
            this.build.setResult(executor.abortResult());
        }
    }
}

