/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.service;

import hudson.EnvVars;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;

public class JenkinsConfigService {
    private final EnvVars envVars;
    private final Node node;
    private final TaskListener listener;

    public JenkinsConfigService(EnvVars envVars, Node node, TaskListener listener) {
        this.envVars = envVars;
        this.node = node;
        this.listener = listener;
    }

    public <T extends GlobalConfiguration> Optional<T> getGlobalConfiguration(Class<T> configurationClass) {
        GlobalConfiguration globalConfig = (GlobalConfiguration)GlobalConfiguration.all().get(configurationClass);
        return Optional.ofNullable(globalConfig);
    }

    public <T extends ToolInstallation, D extends ToolDescriptor<T>> List<T> getToolInstallations(Class<D> descriptorClass) {
        ToolDescriptor toolDescriptor = (ToolDescriptor)ToolInstallation.all().get(descriptorClass);
        if (toolDescriptor == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(toolDescriptor.getInstallations());
    }

    public <T extends ToolInstallation & EnvironmentSpecific<T>, D extends ToolDescriptor<T>> Optional<T> getInstallationForNodeAndEnvironment(Class<D> descriptorClass, String toolInstallationName) throws IOException, InterruptedException {
        Optional<ToolInstallation> environmentReadyToolInstallation = this.getToolInstallations(descriptorClass).stream().filter(installation -> installation.getName().equals(toolInstallationName)).findFirst().map(installation -> (ToolInstallation)((EnvironmentSpecific)installation).forEnvironment(this.envVars));
        if (environmentReadyToolInstallation.isPresent()) {
            ToolInstallation toolInstallation = environmentReadyToolInstallation.get();
            return Optional.ofNullable((ToolInstallation)((NodeSpecific)toolInstallation).forNode(this.node, this.listener));
        }
        return Optional.empty();
    }
}

