/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.service;

import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.OperatingSystemType;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.security.MasterToSlaveCallable;

public class JenkinsRemotingService {
    private final Launcher launcher;
    private final FilePath workspace;
    private final TaskListener listener;

    public JenkinsRemotingService(Launcher launcher, FilePath workspace, TaskListener listener) {
        this.launcher = launcher;
        this.workspace = workspace;
        this.listener = listener;
    }

    public List<String> tokenizeArgumentString(String argumentString) {
        return Arrays.asList(Util.tokenize((String)argumentString));
    }

    public List<String> resolveEnvironmentVariables(IntEnvironmentVariables intEnvironmentVariables, List<String> argumentList) {
        return argumentList.stream().map(argument -> Util.replaceMacro((String)argument, (Map)intEnvironmentVariables.getVariables())).collect(Collectors.toList());
    }

    public int launch(IntEnvironmentVariables intEnvironmentVariables, List<String> commandLine) throws IOException, InterruptedException {
        return this.launcher.launch().cmds(commandLine).envs(intEnvironmentVariables.getVariables()).pwd(this.workspace).stdout(this.listener).quiet(true).join();
    }

    public <T, E extends Throwable> T call(Callable<T, E> callable) throws E, IOException, InterruptedException {
        VirtualChannel virtualChannel = this.launcher.getChannel();
        if (virtualChannel == null) {
            virtualChannel = this.workspace.getChannel();
        }
        return (T)virtualChannel.call(callable);
    }

    public boolean isRemoteUnix() {
        return this.launcher.isUnix();
    }

    public OperatingSystemType getRemoteOperatingSystemType() throws IOException, InterruptedException {
        return (OperatingSystemType)this.call((Callable)new OperatingSystemTypeCallable());
    }

    public String getRemoteWorkspacePath() {
        return this.workspace.getRemote();
    }

    public static class OperatingSystemTypeCallable
    extends MasterToSlaveCallable<OperatingSystemType, RuntimeException> {
        private static final long serialVersionUID = 1943720716430585353L;

        public OperatingSystemType call() {
            return OperatingSystemType.determineFromSystem();
        }
    }
}

