/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.service;

import com.synopsys.integration.jenkins.ChangeSetFilter;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.rest.RestConstants;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public class JenkinsScmService {
    private final JenkinsIntLogger logger;
    private final RunWrapper build;

    public JenkinsScmService(JenkinsIntLogger logger, Run<?, ?> build) {
        this.logger = logger;
        this.build = new RunWrapper(build, true);
    }

    public ChangeSetFilter newChangeSetFilter() {
        return new ChangeSetFilter(this.logger);
    }

    public List<String> getFilePathsFromChangeSet(ChangeSetFilter changeSetFilter) throws Exception {
        return this.build.getChangeSets().stream().filter(changeLogSet -> !changeLogSet.isEmptySet()).flatMap(this::toEntries).peek(this::logEntry).flatMap(this::toAffectedFiles).filter(changeSetFilter::shouldInclude).map(ChangeLogSet.AffectedFile::getPath).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private Stream<? extends ChangeLogSet.Entry> toEntries(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        return StreamSupport.stream(changeLogSet.spliterator(), false);
    }

    private Stream<? extends ChangeLogSet.AffectedFile> toAffectedFiles(ChangeLogSet.Entry entry) {
        return entry.getAffectedFiles().stream();
    }

    private void logEntry(ChangeLogSet.Entry entry) {
        if (this.logger.getLogLevel().isLoggable(LogLevel.DEBUG)) {
            Date date = new Date(entry.getTimestamp());
            this.logger.debug(String.format("Commit %s by %s on %s: %s", entry.getCommitId(), entry.getAuthor(), RestConstants.formatDate((Date)date), entry.getMsg()));
        }
    }
}

