/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.wrapper;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.synopsys.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.jenkins.wrapper.SynopsysCredentialsHelper;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.security.ACL;
import hudson.util.VersionNumber;
import java.util.Collections;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class JenkinsWrapper {
    private Jenkins jenkins;

    public JenkinsWrapper(Jenkins jenkins) {
        this.jenkins = jenkins;
    }

    public static JenkinsWrapper initializeFromJenkinsJVM() {
        return new JenkinsWrapper(Jenkins.getInstanceOrNull());
    }

    public Optional<Jenkins> getJenkins() {
        return Optional.ofNullable(this.jenkins);
    }

    protected Optional<VersionNumber> getVersion() {
        return Optional.ofNullable(Jenkins.getVersion());
    }

    protected <T extends Credentials> Optional<T> getCredentialsById(IdMatcher idMatcher, Class<T> credentialsType) {
        return CredentialsProvider.lookupCredentials(credentialsType, (ItemGroup)this.jenkins, (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(arg_0 -> ((IdMatcher)idMatcher).matches(arg_0)).findAny();
    }

    protected Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.ofNullable(this.jenkins).map(instance -> instance.proxy);
    }

    public void migrateFieldFrom(String oldName, Class clazz, String newName) {
        Items.XSTREAM.aliasField(oldName, clazz, newName);
        Items.XSTREAM.aliasField(newName, clazz, newName);
    }

    public JenkinsVersionHelper getVersionHelper() {
        return new JenkinsVersionHelper(this);
    }

    public JenkinsProxyHelper getProxyHelper() {
        return JenkinsProxyHelper.fromProxyConfiguration(this.getProxyConfiguration().orElse(null));
    }

    public SynopsysCredentialsHelper getCredentialsHelper() {
        return new SynopsysCredentialsHelper(this);
    }
}

