/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.jenkins.wrapper;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.synopsys.integration.jenkins.wrapper.JenkinsWrapper;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import hudson.util.Secret;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;

public class SynopsysCredentialsHelper {
    public static final Class<StringCredentialsImpl> API_TOKEN_CREDENTIALS_CLASS = StringCredentialsImpl.class;
    public static final CredentialsMatcher API_TOKEN_CREDENTIALS = CredentialsMatchers.instanceOf(API_TOKEN_CREDENTIALS_CLASS);
    public static final Class<UsernamePasswordCredentialsImpl> USERNAME_PASSWORD_CREDENTIALS_CLASS = UsernamePasswordCredentialsImpl.class;
    public static final CredentialsMatcher API_TOKEN_OR_USERNAME_PASSWORD_CREDENTIALS = CredentialsMatchers.either((CredentialsMatcher)CredentialsMatchers.instanceOf(API_TOKEN_CREDENTIALS_CLASS), (CredentialsMatcher)CredentialsMatchers.instanceOf(USERNAME_PASSWORD_CREDENTIALS_CLASS));
    private final JenkinsWrapper jenkinsWrapper;

    public SynopsysCredentialsHelper(JenkinsWrapper jenkinsWrapper) {
        this.jenkinsWrapper = jenkinsWrapper;
    }

    public com.synopsys.integration.rest.credentials.Credentials getIntegrationCredentialsById(String credentialsId) {
        Optional<UsernamePasswordCredentialsImpl> credentials = this.getUsernamePasswordCredentialsById(credentialsId);
        CredentialsBuilder credentialsBuilder = com.synopsys.integration.rest.credentials.Credentials.newBuilder();
        credentials.map(UsernamePasswordCredentialsImpl::getUsername).ifPresent(arg_0 -> ((CredentialsBuilder)credentialsBuilder).setUsername(arg_0));
        credentials.map(UsernamePasswordCredentialsImpl::getPassword).map(Secret::getPlainText).ifPresent(arg_0 -> ((CredentialsBuilder)credentialsBuilder).setPassword(arg_0));
        return (com.synopsys.integration.rest.credentials.Credentials)credentialsBuilder.build();
    }

    public Optional<String> getApiTokenByCredentialsId(String credentialsId) {
        return this.getApiTokenCredentialsById(credentialsId).map(StringCredentialsImpl::getSecret).map(Secret::getPlainText);
    }

    public Optional<UsernamePasswordCredentialsImpl> getUsernamePasswordCredentialsById(String credentialsId) {
        return this.getCredentialsById(USERNAME_PASSWORD_CREDENTIALS_CLASS, credentialsId);
    }

    public Optional<StringCredentialsImpl> getApiTokenCredentialsById(String credentialsId) {
        return this.getCredentialsById(API_TOKEN_CREDENTIALS_CLASS, credentialsId);
    }

    public <T extends Credentials> Optional<T> getCredentialsById(Class<T> credentialsType, String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return Optional.empty();
        }
        IdMatcher idMatcher = new IdMatcher(credentialsId);
        return this.jenkinsWrapper.getCredentialsById(idMatcher, credentialsType);
    }
}

