/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.stepworkflow;

import com.synopsys.integration.stepworkflow.StepWorkflowResponse;
import com.synopsys.integration.stepworkflow.SubStep;
import com.synopsys.integration.stepworkflow.SubStepResponse;
import java.util.function.Predicate;

public class StepWorkflow<T> {
    protected FlowController<Object, ?> start;
    protected FlowController<?, T> end;

    protected StepWorkflow(FlowController<Object, ?> start, FlowController<?, T> end) {
        this.start = start;
        this.end = end;
    }

    protected StepWorkflow(FlowController<Object, T> startAndEnd) {
        this.start = startAndEnd;
        this.end = startAndEnd;
    }

    public static <R> Builder<R> first(SubStep<Object, R> firstStep) {
        return new Builder<R>(firstStep);
    }

    public static <R> StepWorkflow<R> just(SubStep<Object, R> onlyStep) {
        return new StepWorkflow<R>(new FlowController<Object, R>(onlyStep));
    }

    public StepWorkflowResponse<T> run() {
        this.start.runStep(SubStepResponse.SUCCESS());
        return new StepWorkflowResponse(this.end.response);
    }

    private SubStepResponse<T> runAsSubStep() {
        this.start.runStep(SubStepResponse.SUCCESS());
        return this.end.response;
    }

    public static class ConditionalBuilder<P, T> {
        protected final Builder<T> conditionalStepWorkflowBuilder;
        protected final Builder<P> parentBuilder;

        protected ConditionalBuilder(Builder<P> parentBuilder, SubStep<Object, T> firstStep) {
            this.parentBuilder = parentBuilder;
            this.conditionalStepWorkflowBuilder = new Builder<T>(firstStep);
        }

        protected <U> ConditionalBuilder(ConditionalBuilder<P, U> currentBuilder, Builder<T> conditionalStepWorkflowBuilder) {
            this.parentBuilder = currentBuilder.parentBuilder;
            this.conditionalStepWorkflowBuilder = conditionalStepWorkflowBuilder;
        }

        public <R> ConditionalBuilder<P, R> then(SubStep<? super T, R> subStep) {
            return new ConditionalBuilder<P, R>(this, this.conditionalStepWorkflowBuilder.then(subStep));
        }

        public <B> Builder<Object> butOnlyIf(B objectToTest, Predicate<B> tester) {
            return this.build(previousResponse -> this.runConditionalWorkflow(objectToTest, tester, previousResponse));
        }

        protected Builder<Object> build(SubStep<P, Object> workflowAsSubstep) {
            return new Builder<Object>(this.parentBuilder, workflowAsSubstep);
        }

        protected <B> SubStepResponse<Object> runConditionalWorkflow(B objectToTest, Predicate<B> tester, SubStepResponse<? extends P> previousResponse) {
            if (previousResponse.isSuccess()) {
                if (tester.test(objectToTest)) {
                    SubStepResponse response = ((StepWorkflow)this.conditionalStepWorkflowBuilder.build()).runAsSubStep();
                    return new SubStepResponse<Object>(response.isSuccess(), null, response.getException());
                }
                return SubStepResponse.SUCCESS();
            }
            return SubStepResponse.FAILURE(previousResponse);
        }
    }

    public static class Builder<T> {
        protected final FlowController<Object, ?> start;
        protected final FlowController<?, T> end;

        protected Builder(SubStep<Object, T> firstStep) {
            FlowController<Object, T> firstFlowController = new FlowController<Object, T>(firstStep);
            this.start = firstFlowController;
            this.end = firstFlowController;
        }

        protected <S> Builder(Builder<S> previousStepWorkflowBuilder, SubStep<? super S, T> thisStep) {
            this.start = previousStepWorkflowBuilder.start;
            this.end = previousStepWorkflowBuilder.end.append(thisStep);
        }

        public <R> Builder<R> then(SubStep<? super T, R> subStep) {
            return new Builder<R>(this, subStep);
        }

        public <R> ConditionalBuilder<T, R> andSometimes(SubStep<Object, R> subStep) {
            return new ConditionalBuilder(this, subStep);
        }

        public StepWorkflow<T> build() {
            return new StepWorkflow<T>(this.start, this.end);
        }

        public StepWorkflowResponse<T> run() {
            return this.build().run();
        }
    }

    protected static class FlowController<U, S> {
        protected final SubStep<U, S> step;
        protected FlowController<? super S, ?> next;
        protected SubStepResponse<S> response;

        protected FlowController(SubStep<U, S> current) {
            this.step = current;
        }

        protected SubStepResponse<S> getResponse() {
            return this.response;
        }

        protected <R> FlowController<?, R> append(SubStep<? super S, R> nextStep) {
            FlowController<? super S, R> nextController = new FlowController<S, R>(nextStep);
            this.next = nextController;
            return nextController;
        }

        protected void runStep(SubStepResponse<? extends U> previousResponse) {
            this.response = this.step.run(previousResponse);
            if (this.next != null) {
                this.next.runStep(this.response);
            }
        }
    }
}

