/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.stepworkflow.jenkins;

import com.google.gson.Gson;
import com.synopsys.integration.jenkins.extensions.JenkinsIntLogger;
import com.synopsys.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.phonehome.PhoneHomeClient;
import com.synopsys.integration.phonehome.PhoneHomeResponse;
import com.synopsys.integration.phonehome.PhoneHomeService;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBody;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBodyBuilder;
import com.synopsys.integration.stepworkflow.StepWorkflow;
import com.synopsys.integration.stepworkflow.StepWorkflowResponse;
import hudson.AbortException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class JenkinsStepWorkflow<T> {
    protected final JenkinsIntLogger logger;
    protected final JenkinsVersionHelper jenkinsVersionHelper;

    public JenkinsStepWorkflow(JenkinsIntLogger logger, JenkinsVersionHelper jenkinsVersionHelper) {
        this.logger = logger;
        this.jenkinsVersionHelper = jenkinsVersionHelper;
    }

    protected abstract PhoneHomeRequestBodyBuilder createPhoneHomeBuilder();

    protected abstract StepWorkflow<T> buildWorkflow() throws AbortException;

    public abstract Object perform() throws Exception;

    protected StepWorkflowResponse<T> runWorkflow() throws AbortException {
        Optional<PhoneHomeResponse> phoneHomeResponse = this.beginPhoneHome();
        try {
            StepWorkflowResponse<T> stepWorkflowResponse = this.buildWorkflow().run();
            return stepWorkflowResponse;
        }
        finally {
            phoneHomeResponse.ifPresent(PhoneHomeResponse::getImmediateResult);
        }
    }

    protected Optional<PhoneHomeResponse> beginPhoneHome() {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            Gson gson = new Gson();
            PhoneHomeClient phoneHomeClient = new PhoneHomeClient((IntLogger)this.logger, httpClientBuilder, gson);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            PhoneHomeService phoneHomeService = PhoneHomeService.createAsynchronousPhoneHomeService((IntLogger)this.logger, (PhoneHomeClient)phoneHomeClient, (ExecutorService)executor);
            PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = this.createPhoneHomeBuilder();
            PhoneHomeRequestBody phoneHomeRequestBody = this.addJenkinsMetadataAndBuildPhoneHomeRequest(phoneHomeRequestBodyBuilder);
            return Optional.ofNullable(phoneHomeService.phoneHome(phoneHomeRequestBody));
        }
        catch (Exception e) {
            this.logger.trace("Phone home failed due to an unexpected exception:", e);
            return Optional.empty();
        }
    }

    protected PhoneHomeRequestBody addJenkinsMetadataAndBuildPhoneHomeRequest(PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) {
        this.jenkinsVersionHelper.getJenkinsVersion().ifPresent(jenkinsVersionString -> phoneHomeRequestBodyBuilder.addToMetaData("jenkins.version", jenkinsVersionString));
        return phoneHomeRequestBodyBuilder.build();
    }
}

