/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key.mnemonic;

import com.syntifi.crypto.key.encdec.Hex;
import com.syntifi.crypto.key.hash.Sha256;
import com.syntifi.crypto.key.mnemonic.Language;
import com.syntifi.crypto.key.mnemonic.exception.MnemonicException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class MnemonicCode {
    private static final int PBKDF2_ROUNDS = 2048;
    private final List<String> wordList;
    private final Language language;

    public MnemonicCode(Language language) throws IOException {
        this.language = language;
        InputStream wordStream = this.getClass().getResourceAsStream("/" + language.getFileName());
        if (wordStream == null) {
            throw new FileNotFoundException(language.getFileName());
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(wordStream, language.getCharset()));
        Object object = null;
        try {
            this.wordList = br.lines().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (object != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        if (this.wordList.size() != 2048) {
            throw new IllegalArgumentException("input stream did not contain 2048 bytes");
        }
        if (language.getCheckSum() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : this.getWordList()) {
                stringBuilder.append(s);
            }
            byte[] digest = Sha256.digest(String.valueOf(stringBuilder).getBytes(language.getCharset()));
            String hexDigest = Hex.encode(digest);
            if (!hexDigest.equals(language.getCheckSum())) {
                throw new IllegalArgumentException("wordlist checksum mismatch");
            }
        }
    }

    public byte[] toSeed(List<String> words) {
        return this.toSeed(words, "");
    }

    public byte[] toSeed(List<String> words, String passphrase) {
        if (passphrase == null) {
            throw new RuntimeException("A null passphrase is not allowed.");
        }
        String pass = String.join((CharSequence)" ", words);
        String salt = "mnemonic" + passphrase;
        PKCS5S2ParametersGenerator pbkdf2 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        pbkdf2.init(pass.getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8), 2048);
        KeyParameter key = (KeyParameter)pbkdf2.generateDerivedParameters(512);
        return key.getKey();
    }

    private boolean[] bytesToBits(byte[] data) {
        boolean[] bits = new boolean[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                bits[i * 8 + j] = (data[i] & 1 << 7 - j) != 0;
            }
        }
        return bits;
    }

    public List<String> getWordList() {
        return this.wordList;
    }

    public byte[] toEntropy(List<String> words) throws MnemonicException.MnemonicLengthException, MnemonicException.MnemonicWordException, MnemonicException.MnemonicChecksumException {
        int ii;
        if (words.size() % 3 > 0) {
            throw new MnemonicException.MnemonicLengthException("Word list size must be multiple of three words.");
        }
        if (words.size() == 0) {
            throw new MnemonicException.MnemonicLengthException("Word list is empty.");
        }
        int concatLenBits = words.size() * 11;
        boolean[] concatBits = new boolean[concatLenBits];
        int wordindex = 0;
        Collator collator = Collator.getInstance(this.language.getLocale());
        for (String word : words) {
            int ndx = Collections.binarySearch(this.wordList, word, collator);
            if (ndx < 0) {
                throw new MnemonicException.MnemonicWordException(word);
            }
            for (ii = 0; ii < 11; ++ii) {
                concatBits[wordindex * 11 + ii] = (ndx & 1 << 10 - ii) != 0;
            }
            ++wordindex;
        }
        int checksumLengthBits = concatLenBits / 33;
        int entropyLengthBits = concatLenBits - checksumLengthBits;
        byte[] entropy = new byte[entropyLengthBits / 8];
        for (ii = 0; ii < entropy.length; ++ii) {
            for (int jj = 0; jj < 8; ++jj) {
                if (!concatBits[ii * 8 + jj]) continue;
                int n = ii;
                entropy[n] = (byte)(entropy[n] | 1 << 7 - jj);
            }
        }
        byte[] hash = Sha256.digest(entropy);
        boolean[] hashBits = this.bytesToBits(hash);
        for (int i = 0; i < checksumLengthBits; ++i) {
            if (concatBits[entropyLengthBits + i] == hashBits[i]) continue;
            throw new MnemonicException.MnemonicChecksumException();
        }
        return entropy;
    }

    public List<String> toMnemonic(byte[] entropy) throws MnemonicException.MnemonicLengthException {
        if (entropy.length % 4 > 0) {
            throw new MnemonicException.MnemonicLengthException("Entropy length not multiple of 32 bits.");
        }
        if (entropy.length == 0) {
            throw new MnemonicException.MnemonicLengthException("Entropy is empty.");
        }
        byte[] hash = Sha256.digest(entropy);
        boolean[] hashBits = this.bytesToBits(hash);
        boolean[] entropyBits = this.bytesToBits(entropy);
        int checksumLengthBits = entropyBits.length / 32;
        boolean[] concatBits = new boolean[entropyBits.length + checksumLengthBits];
        System.arraycopy(entropyBits, 0, concatBits, 0, entropyBits.length);
        System.arraycopy(hashBits, 0, concatBits, entropyBits.length, checksumLengthBits);
        ArrayList<String> words = new ArrayList<String>();
        int nWords = concatBits.length / 11;
        for (int i = 0; i < nWords; ++i) {
            int index = 0;
            for (int j = 0; j < 11; ++j) {
                index <<= 1;
                if (!concatBits[i * 11 + j]) continue;
                index |= 1;
            }
            words.add(this.wordList.get(index));
        }
        return words;
    }

    public void check(List<String> words) throws MnemonicException {
        this.toEntropy(words);
    }

    public List<String> generateSecureRandomWords() throws IOException, MnemonicException.MnemonicLengthException {
        MnemonicCode mnemonicCode = new MnemonicCode(this.language);
        SecureRandom rnd = new SecureRandom();
        byte[] entropy = new byte[16];
        rnd.nextBytes(entropy);
        return mnemonicCode.toMnemonic(entropy);
    }
}

