/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.ASN1Identifiers;
import com.syntifi.crypto.key.AbstractPrivateKey;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.Ed25519PublicKey;
import com.syntifi.crypto.key.PemFileHelper;
import com.syntifi.crypto.key.deterministic.HierarchicalDeterministicKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;

public class Ed25519PrivateKey
extends AbstractPrivateKey {
    private Ed25519PrivateKeyParameters privateKeyParameters;

    public Ed25519PrivateKey(byte[] privateKey) {
        super(privateKey);
        this.loadPrivateKey(privateKey);
    }

    public void loadPrivateKey(byte[] privateKey) {
        this.privateKeyParameters = new Ed25519PrivateKeyParameters(privateKey, 0);
    }

    public void readPrivateKey(String filename) throws IOException {
        ASN1Primitive key = ASN1Primitive.fromByteArray((byte[])PemFileHelper.readPemFile((String)filename));
        PrivateKeyInfo keyInfo = PrivateKeyInfo.getInstance((Object)key);
        String algoId = keyInfo.getPrivateKeyAlgorithm().getAlgorithm().toString();
        if (algoId.equals(ASN1Identifiers.Ed25519OID.getId())) {
            this.privateKeyParameters = new Ed25519PrivateKeyParameters(keyInfo.getPrivateKey().getEncoded(), 4);
            this.setKey(this.privateKeyParameters.getEncoded());
        }
    }

    public void writePrivateKey(String filename) throws IOException {
        DERSequence derPrefix = new DERSequence((ASN1Encodable)ASN1Identifiers.Ed25519OID);
        DEROctetString key = new DEROctetString((ASN1Encodable)new DEROctetString(this.getKey()));
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(0L));
        vector.add((ASN1Encodable)derPrefix);
        vector.add((ASN1Encodable)key);
        DERSequence derKey = new DERSequence(vector);
        PemFileHelper.writePemFile((String)filename, (byte[])derKey.getEncoded(), (String)"PRIVATE KEY");
    }

    public byte[] sign(byte[] message) {
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)this.privateKeyParameters);
        signer.update(message, 0, message.length);
        try {
            byte[] signature = signer.generateSignature();
            return signature;
        }
        catch (CryptoException | DataLengthException e) {
            return null;
        }
    }

    public AbstractPublicKey derivePublicKey() {
        return new Ed25519PublicKey(this.privateKeyParameters.generatePublicKey().getEncoded());
    }

    public static Ed25519PrivateKey deriveFromSeed(byte[] seed, int[] path) throws IOException {
        byte[] init = "ed25519 seed".getBytes(StandardCharsets.UTF_8);
        byte[] key = HierarchicalDeterministicKey.getFromSeed((byte[])seed, (byte[])init, (int[])path);
        return new Ed25519PrivateKey(key);
    }

    public static Ed25519PrivateKey deriveRandomKey() {
        SecureRandom rnd = new SecureRandom();
        Ed25519KeyPairGenerator keyPairGenerator = new Ed25519KeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(rnd));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        Ed25519PrivateKeyParameters privateKeyParameters = (Ed25519PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new Ed25519PrivateKey(privateKeyParameters.getEncoded());
    }

    @Generated
    public Ed25519PrivateKey() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ed25519PrivateKey)) {
            return false;
        }
        Ed25519PrivateKey other = (Ed25519PrivateKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ed25519PrivateKeyParameters this$privateKeyParameters = this.privateKeyParameters;
        Ed25519PrivateKeyParameters other$privateKeyParameters = other.privateKeyParameters;
        return !(this$privateKeyParameters == null ? other$privateKeyParameters != null : !this$privateKeyParameters.equals(other$privateKeyParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Ed25519PrivateKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Ed25519PrivateKeyParameters $privateKeyParameters = this.privateKeyParameters;
        result = result * 59 + ($privateKeyParameters == null ? 43 : $privateKeyParameters.hashCode());
        return result;
    }
}

