/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.ASN1Identifiers;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.PemFileHelper;
import java.io.IOException;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;

public class Ed25519PublicKey
extends AbstractPublicKey {
    private Ed25519PublicKeyParameters publicKeyParameters;

    public Ed25519PublicKey(byte[] publicKey) {
        super(publicKey);
        this.loadPublicKey(publicKey);
    }

    public void loadPublicKey(byte[] publicKey) {
        this.publicKeyParameters = new Ed25519PublicKeyParameters(publicKey, 0);
    }

    public void readPublicKey(String filename) throws IOException {
        ASN1Primitive derKey = ASN1Primitive.fromByteArray((byte[])PemFileHelper.readPemFile((String)filename));
        ASN1Sequence objBaseSeq = ASN1Sequence.getInstance((Object)derKey);
        String objId = ASN1ObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)objBaseSeq.getObjectAt(0)).getObjectAt(0)).getId();
        if (objId.equals(ASN1Identifiers.Ed25519OID.getId())) {
            DERBitString key = DERBitString.getInstance((Object)objBaseSeq.getObjectAt(1));
            this.publicKeyParameters = new Ed25519PublicKeyParameters(key.getBytes(), 0);
            this.setKey(this.publicKeyParameters.getEncoded());
        }
    }

    public void writePublicKey(String filename) throws IOException {
        DERSequence derPrefix = new DERSequence((ASN1Encodable)ASN1Identifiers.Ed25519OID);
        DERBitString key = new DERBitString(this.getKey());
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)derPrefix);
        vector.add((ASN1Encodable)key);
        DERSequence derKey = new DERSequence(vector);
        PemFileHelper.writePemFile((String)filename, (byte[])derKey.getEncoded(), (String)"PUBLIC KEY");
    }

    public Boolean verify(byte[] message, byte[] signature) {
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)this.publicKeyParameters);
        verifier.update(message, 0, message.length);
        return verifier.verifySignature(signature);
    }

    @Generated
    public Ed25519PublicKey() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ed25519PublicKey)) {
            return false;
        }
        Ed25519PublicKey other = (Ed25519PublicKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ed25519PublicKeyParameters this$publicKeyParameters = this.publicKeyParameters;
        Ed25519PublicKeyParameters other$publicKeyParameters = other.publicKeyParameters;
        return !(this$publicKeyParameters == null ? other$publicKeyParameters != null : !this$publicKeyParameters.equals(other$publicKeyParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Ed25519PublicKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Ed25519PublicKeyParameters $publicKeyParameters = this.publicKeyParameters;
        result = result * 59 + ($publicKeyParameters == null ? 43 : $publicKeyParameters.hashCode());
        return result;
    }
}

