/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.ASN1Identifiers;
import com.syntifi.crypto.key.AbstractPrivateKey;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.PemFileHelper;
import com.syntifi.crypto.key.Secp256k1PublicKey;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class Secp256k1PrivateKey
extends AbstractPrivateKey {
    private ECKeyPair keyPair;

    public Secp256k1PrivateKey(byte[] privateKey) throws IOException {
        super(privateKey);
        this.loadPrivateKey(privateKey);
    }

    public void loadPrivateKey(byte[] privateKey) throws IOException {
        ASN1Sequence key = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])privateKey);
        String algoId = key.getObjectAt(2).toString();
        if (algoId.equals("[0]" + ASN1Identifiers.Secp256k1OIDCurve) && key.getObjectAt(0).toString().equals("1")) {
            DEROctetString pk = (DEROctetString)key.getObjectAt(1);
            this.keyPair = ECKeyPair.create((byte[])pk.getOctets());
            this.setKey(this.keyPair.getPrivateKey().toByteArray());
        }
    }

    public void readPrivateKey(String filename) throws IOException {
        this.loadPrivateKey(PemFileHelper.readPemFile((String)filename));
    }

    public void writePrivateKey(String filename) throws IOException {
        try (FileWriter fileWriter = new FileWriter(filename);){
            DERTaggedObject derPrefix = new DERTaggedObject(0, (ASN1Encodable)ASN1Identifiers.Secp256k1OIDCurve);
            DEROctetString key = new DEROctetString(this.getKey());
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new ASN1Integer(1L));
            vector.add((ASN1Encodable)key);
            vector.add((ASN1Encodable)derPrefix);
            DERSequence derKey = new DERSequence(vector);
            PemFileHelper.writePemFile((Writer)fileWriter, (byte[])derKey.getEncoded(), (String)"EC PRIVATE KEY");
        }
    }

    public byte[] sign(byte[] message) {
        Sign.SignatureData signature = Sign.signMessage((byte[])Hash.sha256((byte[])message), (ECKeyPair)this.keyPair, (boolean)false);
        ByteBuffer bb = ByteBuffer.allocate(signature.getR().length + signature.getS().length);
        bb.put(signature.getR());
        bb.put(signature.getS());
        return bb.array();
    }

    public AbstractPublicKey derivePublicKey() {
        BigInteger pubKey = this.keyPair.getPublicKey();
        byte[] pubKeyBytes = Secp256k1PublicKey.getShortKey(pubKey.toByteArray());
        return new Secp256k1PublicKey(pubKeyBytes);
    }

    public static Secp256k1PrivateKey deriveRandomKey() throws IOException {
        SecureRandom rnd = new SecureRandom();
        ECKeyPair keyPair = ECKeyPair.create((byte[])rnd.generateSeed(32));
        Secp256k1PrivateKey sk = new Secp256k1PrivateKey();
        sk.setKeyPair(keyPair);
        return sk;
    }

    @Generated
    public Secp256k1PrivateKey() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secp256k1PrivateKey)) {
            return false;
        }
        Secp256k1PrivateKey other = (Secp256k1PrivateKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ECKeyPair this$keyPair = this.getKeyPair();
        ECKeyPair other$keyPair = other.getKeyPair();
        return !(this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Secp256k1PrivateKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ECKeyPair $keyPair = this.getKeyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        return result;
    }

    @Generated
    public ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Generated
    public void setKeyPair(ECKeyPair keyPair) {
        this.keyPair = keyPair;
    }
}

