/*
 * Decompiled with CFR 0.152.
 */
package com.systemsplanet.maven.plugin;

import com.google.api.translate.Language;
import com.google.api.translate.Translate;
import com.systemsplanet.util.OrderedProperties;
import java.io.IOException;

class EventProcessor {
    static int callsToGoogle = 0;
    static int maxCalls = 100;
    static int pauseMs = 5000;
    Boolean debug;
    String sourceLanguage;
    String destLanguage;
    String key;
    OrderedProperties properties;

    public EventProcessor(Boolean debug, String sourceLanguage, String destLanguage, String key, OrderedProperties properties) {
        Translate.setHttpReferrer((String)"http://localhost");
        this.debug = debug;
        this.sourceLanguage = sourceLanguage;
        this.destLanguage = destLanguage;
        this.key = key;
        this.properties = properties;
    }

    public void foundMarkup(String markup) throws IOException {
        String currentValue = this.properties.getProperty(this.key, "");
        this.properties.setProperty(this.key, currentValue + markup);
    }

    public void foundContent(String content) throws IOException {
        if (this.debug.booleanValue()) {
            System.out.println("\n[" + content + "]BEFORE");
        }
        String translatedText = content;
        try {
            if (content.trim().length() > 0) {
                String prefix = this.stripFront(content);
                String suffix = this.stripEnd(content);
                content = content.trim();
                if (++callsToGoogle % maxCalls == 0) {
                    System.out.print("\r pauzing " + pauseMs / 1000 + " seconds every " + maxCalls + " calls to google");
                    Thread.sleep(pauseMs);
                    System.out.print("\r resuming...");
                }
                translatedText = Translate.execute((String)content, (Language)Language.fromString((String)this.sourceLanguage), (Language)Language.fromString((String)this.destLanguage));
                translatedText = prefix + translatedText + suffix;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR src:[" + content + "] srcLang:" + this.sourceLanguage + " dstLang:" + this.destLanguage + " err:" + e.getMessage());
        }
        if (this.debug.booleanValue()) {
            System.out.println("[" + translatedText + "]");
        }
        String currentValue = this.properties.getProperty(this.key, "");
        this.properties.setProperty(this.key, currentValue + translatedText);
    }

    private String stripFront(String s) {
        int st;
        int len = s.length();
        char[] val = s.toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        return st > 0 ? s.substring(0, st) : "";
    }

    private String stripEnd(String s) {
        int len = s.length();
        int c = 0;
        char[] val = s.toCharArray();
        while (len > 0 && val[len - 1] <= ' ') {
            --len;
            ++c;
        }
        return c > 0 ? s.substring(s.length() - c) : "";
    }
}

