/*
 * Decompiled with CFR 0.152.
 */
package com.systemsplanet.maven.plugin;

import com.systemsplanet.maven.plugin.EventProcessor;
import com.systemsplanet.util.OrderedProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LocalizeMojo
extends AbstractMojo {
    private String[] sourceTranslationFiles;
    private int maxCalls;
    private int pauseSeconds;
    private Boolean debug;
    private Boolean showProgress;
    private File sourceTranslationPath;
    private String sourceTranslationFile;
    private String languageFilePattern;
    private String[] languageFilePatterns;
    private String sourceLanguage;
    private File destinationPath;
    private String[] destinationPaths;
    private String targetLanguages;
    private String sourceFileEncoding;
    private String destinationFileEncoding;
    private Boolean destinationFileEncodingIncludeBOM;
    private String[] excludeProperties;
    private String[] passThruProperties;
    private boolean includeDateHeader;
    private String commentHeader;
    private Boolean smartSync;
    private String smartSyncChangeFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EventProcessor.maxCalls = this.maxCalls;
        EventProcessor.pauseMs = 1000 * this.pauseSeconds;
        OrderedProperties.setIncludeDateHeader(this.includeDateHeader);
        if (this.sourceFileEncoding == null || this.sourceFileEncoding.trim().length() == 0) {
            this.sourceFileEncoding = this.destinationFileEncoding;
        }
        if (this.sourceTranslationFiles == null || this.sourceTranslationFiles.length == 0) {
            this.executeFileTranslation(this.sourceTranslationFile, this.sourceTranslationPath, this.languageFilePattern, this.destinationPath, this.smartSyncChangeFile);
        } else {
            if (this.debug.booleanValue()) {
                System.out.println("processing files: " + this.sourceTranslationFiles);
            }
            for (int i = 0; i < this.sourceTranslationFiles.length; ++i) {
                String sourceFile = this.sourceTranslationFiles[i];
                File file = new File(sourceFile);
                if (!file.exists() || !file.isFile()) continue;
                String smartSyncChangeFileName = this.getSmartSyncFileName(file);
                String destinationFilePattern = this.getDestinationFilePattern(i, file);
                File destinationPathFile = this.getDestinationFilePath(i, file);
                this.executeFileTranslation(file.getName(), file.getParentFile(), destinationFilePattern, destinationPathFile, smartSyncChangeFileName);
            }
        }
    }

    private File getDestinationFilePath(int i, File file) {
        File destinationPathFile = null;
        if (this.destinationPaths != null && i < this.destinationPaths.length) {
            String destinationPathString = this.destinationPaths[i];
            destinationPathFile = new File(destinationPathString);
        } else {
            destinationPathFile = this.destinationPath != null ? this.destinationPath : file.getParentFile();
        }
        return destinationPathFile;
    }

    private String getDestinationFilePattern(int i, File file) {
        String destinationFilePattern = null;
        destinationFilePattern = this.languageFilePatterns != null && i < this.languageFilePatterns.length ? this.languageFilePatterns[i] : (this.languageFilePattern != null && !this.languageFilePattern.isEmpty() ? this.languageFilePattern : (file.getName().indexOf("_") > -1 ? file.getName().substring(0, file.getName().indexOf("_")) + "_{0}.properties" : file.getName().replaceFirst(".properties", "_{0}.properties")));
        return destinationFilePattern;
    }

    private String getSmartSyncFileName(File file) {
        String smartSyncChangeFileName = null;
        if (this.smartSyncChangeFile != null && !this.smartSyncChangeFile.isEmpty()) {
            smartSyncChangeFileName = this.smartSyncChangeFile + "_" + file.getName();
        }
        if (this.debug.booleanValue()) {
            System.out.println("smart-sync file: " + smartSyncChangeFileName);
        }
        return smartSyncChangeFileName;
    }

    public void executeFileTranslation(String sourceTranslationFileString, File sourceTranslationPath, String languageFilePattern, File destinationPath, String smartSyncChangeFile) throws MojoExecutionException, MojoFailureException {
        Object[] arguments = new Object[]{this.sourceLanguage};
        String sourceTranslationFileName = sourceTranslationFileString == null || sourceTranslationFileString.isEmpty() ? MessageFormat.format(sourceTranslationPath + File.separator + languageFilePattern, arguments) : MessageFormat.format(sourceTranslationPath + File.separator + sourceTranslationFileString, arguments);
        File sourceTranslationFile = new File(sourceTranslationFileName);
        if (this.debug.booleanValue()) {
            System.out.println("sourceTranslationPath: [" + sourceTranslationPath + "]");
            System.out.println("languageFilePattern: [" + languageFilePattern + "]");
            System.out.println("sourceLanguage: [" + this.sourceLanguage + "]");
            System.out.println("sourceTranslationFileName: [" + sourceTranslationFileName + "]");
            System.out.println("sourceTranslationFile [" + sourceTranslationFile.getAbsolutePath() + "]");
            System.out.println("destinationPath [" + destinationPath.getAbsolutePath() + "]");
        }
        if (!destinationPath.exists()) {
            destinationPath.mkdirs();
        }
        InputStreamReader sourceReader = null;
        InputStream fis = null;
        BufferedWriter bw = null;
        try {
            String[] languages = this.targetLanguages.split(",");
            OrderedProperties sourceProperties = new OrderedProperties();
            OrderedProperties sourceChangeProperties = new OrderedProperties();
            sourceReader = new InputStreamReader((InputStream)new FileInputStream(sourceTranslationFile.getAbsolutePath()), this.sourceFileEncoding);
            sourceProperties.load(sourceReader);
            ((Reader)sourceReader).close();
            sourceReader = null;
            if (this.smartSync.booleanValue()) {
                if (this.debug.booleanValue()) {
                    System.out.println("SMART-SYNC is enabled");
                }
                if (smartSyncChangeFile != null && !smartSyncChangeFile.isEmpty()) {
                    String sourceChangeFileName = destinationPath + File.separator + smartSyncChangeFile;
                    File sourceChangeFile = new File(sourceChangeFileName);
                    if (sourceChangeFile.exists()) {
                        fis = new FileInputStream(sourceChangeFile.getAbsolutePath());
                        sourceChangeProperties.load(fis);
                        fis.close();
                        fis = null;
                        if (this.debug.booleanValue()) {
                            System.out.println("SMART-SYNC CHANGE FILE LOADED: " + sourceChangeFileName);
                        }
                        Set<String> keys = sourceProperties.propertyNames();
                        for (String key : keys) {
                            if (!sourceProperties.getProperty(key).equals(sourceChangeProperties.getProperty(key))) continue;
                            sourceChangeProperties.remove(key);
                            if (!this.debug.booleanValue()) continue;
                            System.out.println("SMART-SYNC EXCLUDING UNCHANGED PROPERTY: " + key);
                        }
                    } else {
                        if (this.debug.booleanValue()) {
                            System.out.println("CREATING SMART-SYNC file: " + sourceChangeFileName);
                        }
                        sourceChangeFile.getParentFile().mkdirs();
                        sourceChangeFile.createNewFile();
                    }
                }
            }
            int languageIndex = 0;
            int propertyIndex = 0;
            for (String destLanguage : languages) {
                File outputFile;
                ++languageIndex;
                Object[] args = new Object[]{destLanguage};
                String destTranslationFileName = MessageFormat.format(destinationPath + File.separator + languageFilePattern, args);
                if (this.debug.booleanValue()) {
                    System.out.println("destTranslationFileName:" + destTranslationFileName);
                }
                OrderedProperties outputPropertiesLoaded = null;
                if (this.smartSync.booleanValue() && (outputFile = new File(destTranslationFileName)).exists()) {
                    outputPropertiesLoaded = new OrderedProperties();
                    FileInputStream fisOutputFile = new FileInputStream(destTranslationFileName);
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fisOutputFile, this.destinationFileEncoding));
                    outputPropertiesLoaded.load(reader);
                    reader.close();
                    fisOutputFile.close();
                    reader = null;
                    fisOutputFile = null;
                    if (this.debug.booleanValue()) {
                        System.out.println("SMART-SYNC DESTINATION FILE LOADED: " + destTranslationFileName);
                    }
                }
                FileOutputStream fos = new FileOutputStream(destTranslationFileName);
                if (this.destinationFileEncoding == null || this.destinationFileEncoding.isEmpty()) {
                    bw = new BufferedWriter(new OutputStreamWriter(fos));
                } else {
                    byte[] bom;
                    if (this.destinationFileEncodingIncludeBOM.booleanValue() && (bom = this.getEncodingBOM(this.destinationFileEncoding)).length > 0) {
                        fos.write(bom);
                    }
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.destinationFileEncoding));
                }
                OrderedProperties outputProperties = new OrderedProperties();
                Set<String> keys = sourceProperties.propertyNames();
                int propertyCount = keys.size();
                int languageCount = languages.length;
                int propertyTranslationsCount = propertyCount * languageCount;
                try {
                    for (String msgKey : keys) {
                        int percentComplete = ++propertyIndex * 100 / propertyTranslationsCount;
                        String msgVal = sourceProperties.getProperty(msgKey);
                        if (this.debug.booleanValue()) {
                            System.out.println(msgKey + "=[" + this.sourceLanguage + "]" + msgVal);
                        } else if (this.showProgress.booleanValue()) {
                            System.out.print("\r[ " + percentComplete + "% ] (" + sourceTranslationFile.getName() + ", language " + languageIndex + " of " + languageCount + ") : (translation " + propertyIndex + " of " + propertyTranslationsCount + ") [" + destLanguage + "]    ");
                        } else {
                            System.out.print(".");
                        }
                        if (this.debug.booleanValue()) {
                            if (this.showProgress.booleanValue()) {
                                System.out.println("[ " + percentComplete + "% ] (language " + languageIndex + " of " + languageCount + ") : (translation " + propertyIndex + " of " + propertyTranslationsCount + ") [" + destLanguage + "]    ");
                            }
                            System.out.print(msgKey + "=[" + destLanguage + "]");
                        }
                        if (this.isExcludedProperty(msgKey)) {
                            if (!this.debug.booleanValue()) continue;
                            System.out.println(" ** EXCLUDED **");
                            continue;
                        }
                        if (this.isPassThruProperty(msgKey)) {
                            outputProperties.setProperty(msgKey, sourceProperties.getProperty(msgKey));
                            continue;
                        }
                        if (this.smartSync.booleanValue() && outputPropertiesLoaded != null && outputPropertiesLoaded.containsKey(msgKey) && !sourceChangeProperties.containsKey(msgKey)) {
                            outputProperties.setProperty(msgKey, outputPropertiesLoaded.getProperty(msgKey));
                            if (!this.debug.booleanValue()) continue;
                            System.out.println(" ** TRANSLATED VALUE ALREADY EXISTS **");
                            continue;
                        }
                        EventProcessor e = new EventProcessor(this.debug, this.sourceLanguage, destLanguage, msgKey, outputProperties);
                        this.parse(new ByteArrayInputStream(msgVal.getBytes()), e);
                    }
                    outputProperties.store(bw, this.commentHeader);
                    bw.close();
                    bw = null;
                    if (smartSyncChangeFile == null || smartSyncChangeFile.isEmpty()) continue;
                    String destChangeFileName = destinationPath + File.separator + smartSyncChangeFile;
                    File destChangeFile = new File(destChangeFileName);
                    sourceProperties.store(new FileWriter(destChangeFile, false), "SOURCE CHANGE FILE");
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    void parse(InputStream is, EventProcessor e) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ch = 0;
        while (ch != -1) {
            if (!this.isMarkup(ch)) {
                ch = is.read();
            }
            if (ch == -1) break;
            if ((char)ch == '$') {
                this.notifyContent(sb, e);
                ch = this.skipMarkup(36, 93, is, e);
                continue;
            }
            if ((char)ch == '<') {
                this.notifyContent(sb, e);
                ch = this.skipMarkup(60, 62, is, e);
                continue;
            }
            if ((char)ch == '{') {
                this.notifyContent(sb, e);
                ch = this.skipMarkup(123, 125, is, e);
                continue;
            }
            if (this.isContent(ch)) {
                sb.append((char)ch);
                continue;
            }
            this.notifyContent(sb, e);
            if ((ch = this.skipToContent(ch, is, e)) == -1 || this.isMarkup(ch)) continue;
            sb.append((char)ch);
        }
        this.notifyContent(sb, e);
    }

    void notifyContent(StringBuffer sb, EventProcessor e) throws IOException {
        if (sb.length() > 0) {
            e.foundContent(sb.toString());
            sb.setLength(0);
        }
    }

    int skipToContent(int ch, InputStream is, EventProcessor e) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append((char)ch);
        while ((ch = is.read()) != -1 && !this.isContent(ch) && !this.isMarkup(ch)) {
            sb.append((char)ch);
        }
        e.foundMarkup(sb.toString());
        return ch;
    }

    int skipMarkup(int start, int end, InputStream is, EventProcessor e) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append((char)start);
        int ch = 0;
        while ((ch = is.read()) != -1) {
            sb.append((char)ch);
            if (ch != end) continue;
        }
        e.foundMarkup(sb.toString());
        return ch;
    }

    boolean isContent(int c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        return c == 32 || c == 9 || c == 39 || c == 44 || c == 46 || c == 63 || c == 33;
    }

    boolean isMarkup(int c) {
        return c == 123 || c == 60 || c == 36;
    }

    byte[] getEncodingBOM(String encoding) {
        byte[] utf32BE_bom = new byte[]{0, 0, -2, -1};
        byte[] utf32LE_bom = new byte[]{-1, -2, 0, 0};
        byte[] utf16BE_bom = new byte[]{-2, -1};
        byte[] utf16LE_bom = new byte[]{-1, -2};
        byte[] utf8_bom = new byte[]{-17, -69, -65};
        byte[] no_bom = new byte[]{};
        if (encoding.equalsIgnoreCase("utf-32be")) {
            return utf32BE_bom;
        }
        if (encoding.equalsIgnoreCase("utf-32le")) {
            return utf32LE_bom;
        }
        if (encoding.equalsIgnoreCase("utf-16be") || encoding.equalsIgnoreCase("unicodebigunmarked")) {
            return utf16BE_bom;
        }
        if (encoding.equalsIgnoreCase("utf-16le") || encoding.equalsIgnoreCase("unicodelittleunmarked")) {
            return utf16LE_bom;
        }
        if (encoding.equalsIgnoreCase("utf-8") || encoding.equalsIgnoreCase("utf8")) {
            return utf8_bom;
        }
        return no_bom;
    }

    boolean isExcludedProperty(String key) {
        if (this.excludeProperties == null) {
            return false;
        }
        for (int index = 0; index < this.excludeProperties.length; ++index) {
            if (this.excludeProperties[index].toString().trim().equals(key.trim())) {
                return true;
            }
            if (!key.trim().matches(this.excludeProperties[index].toString().trim())) continue;
            return true;
        }
        return false;
    }

    boolean isPassThruProperty(String key) {
        if (this.passThruProperties == null) {
            return false;
        }
        for (int index = 0; index < this.passThruProperties.length; ++index) {
            if (this.passThruProperties[index].toString().trim().equals(key.trim())) {
                return true;
            }
            if (!key.trim().matches(this.passThruProperties[index].toString().trim())) continue;
            return true;
        }
        return false;
    }
}

