/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.taboola.android.GLHelper;
import com.taboola.android.R;
import com.taboola.android.TaboolaWebView;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.listeners.TaboolaDetectAdEventsListener;
import com.taboola.android.listeners.TaboolaEventListener;
import com.taboola.android.utils.AssetUtil;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.TaboolaSerializable;
import com.taboola.android.utils.VisibilityUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TaboolaWidget
extends LinearLayout {
    private static final String TAG = TaboolaWidget.class.getSimpleName();
    private static final String HTML_TEMPLATE_FILE_NAME = "template.html";
    private static final String CUSTOM_TAB_PACKAGE_NAME = "com.android.chrome";
    private static int sMaxWidgetSize = 0;
    private static Boolean isSdkMonitorInstalled = null;
    private CustomTabsClient mCustomTabsClient = null;
    private CustomTabsSession mCustomTabsSession = null;
    private CustomTabsServiceConnection mCustomTabsServiceConnection = null;
    private TaboolaWebView mTaboolaWebView;
    private TaboolaEventListener mEventListener;
    private TaboolaDetectAdEventsListener mTaboolaDetectAdEventsListener;
    private MediationEventListener mMediationEventListener;
    private boolean mHasDispatchedLoadEvent = false;
    private boolean isChromeTabLaunched = false;
    private boolean isContextActivity = false;
    private boolean isCustomTabsSupported = false;
    private boolean shouldCheckCacheSize = false;
    private ArrayList<Map<String, String>> mCommands;
    private boolean mIsItemClickEnabled;
    private String mPublisher;
    private String mMode;
    private String mPlacement;
    private String mPageType;
    private String mTargetType;
    private String mPageId;
    private String mPageUrl;
    private String mWidgetStyle;
    private String mFramework;
    private String mViewID;
    @Nullable
    private String mMediatedVia;
    private boolean mIsScrollEnabled;
    private boolean mIsAutoResizeHeight;
    private int mWidgetMaxHeight;
    private boolean shouldAllowNonOrganicClickOverride = false;
    private Handler mInvalidationHandler;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private boolean shouldIgnoreScrollEvents = false;

    public TaboolaWidget(Context context) {
        this(context, null);
    }

    public TaboolaWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWidget();
        this.initWebView();
        this.parseXmlAttributes(context, attrs);
        Logger.d(TAG, "initialized basic components");
    }

    private void initWidget() {
        Context context = this.getContext();
        this.isContextActivity = context instanceof Activity;
        this.isCustomTabsSupported = OnClickHelper.areChromeCustomTabsSupported(context);
        TaboolaJs.getInstance().init(context.getApplicationContext());
        if (!this.isContextActivity) {
            Logger.w(TAG, "Widget should be created using Activity context if possible");
        }
        if (isSdkMonitorInstalled == null) {
            isSdkMonitorInstalled = MonitorUtils.isSdkMonitorInstalled(context);
            this.setLogLevel(3);
        }
        this.updateMaxWidgetSize();
        this.mWidgetMaxHeight = SdkDetailsHelper.getDisplayHeight(context);
        this.mCommands = new ArrayList();
        this.setDefValues();
        this.setGravity(17);
        this.setSaveEnabled(true);
        this.setWillNotDraw(false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void initWebView() {
        if (this.mTaboolaWebView == null) {
            this.mTaboolaWebView = new TaboolaWebView(this.getContext());
            this.mTaboolaWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mTaboolaWebView.setBackgroundColor(0);
            this.addView((View)this.mTaboolaWebView);
            this.mTaboolaWebView.getSettings().setLoadsImagesAutomatically(true);
            this.mTaboolaWebView.getSettings().setLoadWithOverviewMode(true);
            this.mTaboolaWebView.getSettings().setJavaScriptEnabled(true);
            this.mTaboolaWebView.getSettings().setDomStorageEnabled(true);
            this.mTaboolaWebView.getSettings().setAppCacheEnabled(true);
            this.mTaboolaWebView.getSettings().setUseWideViewPort(true);
            this.mTaboolaWebView.setWebViewClient(this.getWebViewClient());
            this.mTaboolaWebView.setWebChromeClient(this.getWebChromeClient());
            this.mTaboolaWebView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            this.mTaboolaWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
            this.mTaboolaWebView.getSettings().setCacheMode(1);
            if (Build.VERSION.SDK_INT >= 19) {
                this.mTaboolaWebView.setLayerType(2, null);
            } else if (Build.VERSION.SDK_INT >= 11) {
                this.mTaboolaWebView.setLayerType(1, null);
                this.shouldCheckCacheSize = true;
            }
            if (Build.VERSION.SDK_INT >= 19 && Logger.getLogLevel() <= 3) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
            }
            Logger.d(TAG, "initWebView :: initialized WebView");
        }
        CookieManager.getInstance().setAcceptCookie(true);
        this.updateScrollBehaviour();
        TaboolaJs.getInstance().registerWebView(this.mTaboolaWebView);
        TaboolaJs.getInstance().setOnRenderListener(this.mTaboolaWebView, new OnRenderListener(){

            @Override
            public void onRenderSuccessful(WebView webView, String placementName, int height) {
                if (Build.VERSION.SDK_INT <= 19) {
                    TaboolaWidget.this.startInvalidationOnScrollEvents();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TaboolaWidget.this.invalidateWebView();
                        }
                    }, 3000L);
                }
                Log.d((String)TAG, (String)("onRenderSuccessful: " + placementName));
                TaboolaWidget.this.dispatchLoadSuccessful();
            }

            @Override
            public void onRenderFailed(WebView webView, String placementName, String errorMessage) {
                Log.e((String)TAG, (String)("onRenderFailed: " + placementName + " " + errorMessage));
                TaboolaWidget.this.dispatchLoadFailed(errorMessage);
            }
        });
        TaboolaJs.getInstance().setOnResizeListener(this.mTaboolaWebView, new OnResizeListener(){

            @Override
            public void onResize(WebView webView, String placementName, int height) {
                int heightPx = VisibilityUtil.convertCssPixelToPixel(height);
                TaboolaWidget.this.resizeWidget(heightPx);
            }
        });
        TaboolaJs.getInstance().setOnClickListener(new TaboolaOnClickListener(){

            @Override
            public boolean onItemClick(String placementName, String itemId, String clickUrl, boolean isOrganic) {
                TaboolaWidget.this.onItemClick(clickUrl, isOrganic);
                return false;
            }
        });
    }

    private void parseXmlAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TaboolaWidget, 0, 0);
        String pageType = a.getString(R.styleable.TaboolaWidget_pageType);
        String targetType = a.getString(R.styleable.TaboolaWidget_targetType);
        String pageUrl = a.getString(R.styleable.TaboolaWidget_pageUrl);
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_autoResizeHeight, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scrollEnabled, this.mIsScrollEnabled));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_itemClickEnabled, this.mIsItemClickEnabled));
        String newPageType = a.getString(R.styleable.TaboolaWidget_page_type);
        String newTargetType = a.getString(R.styleable.TaboolaWidget_target_type);
        String newPageUrl = a.getString(R.styleable.TaboolaWidget_url);
        if (newPageType != null) {
            pageType = newPageType;
        }
        if (newTargetType != null) {
            targetType = newTargetType;
        }
        if (newPageUrl != null) {
            pageUrl = newPageUrl;
        }
        String mode = a.getString(R.styleable.TaboolaWidget_mode);
        String publisher = a.getString(R.styleable.TaboolaWidget_publisher);
        String placement = a.getString(R.styleable.TaboolaWidget_placement);
        this.setAutoResizeHeight(a.getBoolean(R.styleable.TaboolaWidget_auto_resize_height, this.mIsAutoResizeHeight));
        this.setScrollEnabled(a.getBoolean(R.styleable.TaboolaWidget_scroll_enabled, this.mIsScrollEnabled));
        this.setItemClickEnabled(a.getBoolean(R.styleable.TaboolaWidget_item_click_enabled, this.mIsItemClickEnabled));
        if (pageType != null) {
            this.setPageType(pageType);
        }
        if (targetType != null) {
            this.setTargetType(targetType);
        }
        if (pageUrl != null) {
            this.setPageUrl(pageUrl);
        }
        if (mode != null) {
            this.setMode(mode);
        }
        if (publisher != null) {
            this.setPublisher(publisher);
        }
        if (placement != null) {
            this.setPlacement(placement);
        }
        if (this.mViewID == null) {
            this.setViewId(null);
        }
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Logger.d(TAG, "onAttachedToWindow");
        this.bindCustomTabsService();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Logger.d(TAG, "onDetachedFromWindow");
        this.unbindCustomTabsService();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.isChromeTabLaunched && visibility == 0) {
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdClosed();
            }
            this.isChromeTabLaunched = false;
        }
    }

    public TaboolaWidget fetchContent() {
        Logger.d(TAG, "publisher[" + this.mPublisher + "] mode[" + this.mMode + "] placement[" + this.mPlacement + "] pageType[" + this.mPageType + "] pageUrl[" + this.mPageUrl + "] viewID[" + this.mViewID + "]");
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.put("allowNonOrganicClickOverride", "true");
        extraProperties.put("isUsedInTaboolaWidget", "true");
        extraProperties.put("mediatedVia", this.mMediatedVia);
        TaboolaJs.getInstance().setExtraProperties(this.mTaboolaWebView, extraProperties);
        if (this.hasMinimalAttributes()) {
            this.clearWebView();
            this.mHasDispatchedLoadEvent = false;
            this.loadWebView();
        } else {
            String message = "Required parameters are not set";
            Logger.e(TAG, message);
            this.dispatchLoadFailed(message);
        }
        return this;
    }

    public TaboolaWidget refresh() {
        if (this.mTaboolaWebView != null) {
            this.fetchContent();
        }
        return this;
    }

    public TaboolaWidget reset() {
        this.mCommands = new ArrayList();
        this.setDefValues();
        this.clearWebView();
        return this;
    }

    private void clearWebView() {
        this.mTaboolaWebView.loadUrl("about:blank");
        this.mTaboolaWebView.clearHistory();
    }

    private void loadWebView() {
        String baseUrl = "https://cdn.taboola.com/mobile-sdk/init/";
        String commandsString = this.getCommandsString();
        String html = String.format(AssetUtil.getHtmlTemplateFileContent(this.getContext(), HTML_TEMPLATE_FILE_NAME), this.mWidgetStyle, this.mPublisher, commandsString, this.mPageType, this.mPageId, this.mPageUrl, this.mMode, this.mPlacement, this.mFramework, this.mTargetType, this.mPublisher, this.mViewID);
        Logger.d(TAG, "loadWebView html:\n" + html);
        this.mHasDispatchedLoadEvent = false;
        this.mTaboolaWebView.loadDataWithBaseURL(baseUrl, html, "text/html", "utf-8", null);
    }

    private String getCommandsString() {
        StringBuilder retVal = new StringBuilder();
        for (Map<String, String> currItem : this.mCommands) {
            retVal.append("_taboola.push(").append(this.commandToString(currItem)).append(");");
        }
        Logger.v(TAG, "getCommandsString  " + retVal.toString());
        return retVal.toString();
    }

    private String commandToString(Map<String, String> cmd) {
        StringBuilder retValue = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> currElement : cmd.entrySet()) {
            if (!isFirst) {
                retValue.append(",");
            } else {
                isFirst = false;
            }
            String cmdName = currElement.getKey();
            String cmdValue = currElement.getValue();
            retValue.append(cmdName).append(":'").append(cmdValue).append("'");
        }
        Logger.v(TAG, " commandToString   {" + retValue.toString() + "}");
        return "{" + retValue.toString() + "}";
    }

    private void dispatchLoadSuccessful() {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidReceiveAd(this);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdLoaded();
            }
            this.postGlobalNotification("TABOOLA_DID_RECEIVE_AD", this, null);
        }
    }

    private void dispatchLoadFailed(String description) {
        if (!this.mHasDispatchedLoadEvent) {
            this.mHasDispatchedLoadEvent = true;
            if (this.mTaboolaDetectAdEventsListener != null) {
                this.mTaboolaDetectAdEventsListener.onTaboolaDidFailAd(description);
            }
            if (this.mMediationEventListener != null) {
                this.mMediationEventListener.onAdFailedToLoad(description);
            }
            this.postGlobalNotification("TABOOLA_DID_FAIL_AD", this, description);
        }
    }

    private void postGlobalNotification(String message, TaboolaWidget taboolaWidget, @Nullable Object value) {
        Intent intent = new Intent("com.taboola.android.GLOBAL_NOTIFICATIONS_KEY");
        intent.putExtra("GLOBAL_NOTIFICATIONS_MESSAGES_KEY", message);
        TaboolaSerializable taboolaSerializable = new TaboolaSerializable();
        taboolaSerializable.setTaboolaWidget(taboolaWidget);
        intent.putExtra("GLOBAL_NOTIFICATIONS_WIDGET_KEY", (Serializable)taboolaSerializable);
        switch (message) {
            case "TABOOLA_VIEW_RESIZED": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", ((Integer)value).intValue());
                break;
            }
            case "TABOOLA_DID_FAIL_AD": {
                intent.putExtra("GLOBAL_NOTIFICATIONS_VALUE_KEY", (String)value);
            }
        }
        LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
        Logger.d(TAG, "post global notification " + message);
    }

    private void resizeWidget(final int heightPx) {
        Logger.v(TAG, "resizeWidget(" + heightPx + ")");
        if (this.mIsAutoResizeHeight) {
            ViewGroup.LayoutParams params;
            if (sMaxWidgetSize == 0) {
                Log.d((String)TAG, (String)"resizeWidget: postponing resizing until max widget size is resolved");
                Handler mainHandler = new Handler(this.getContext().getMainLooper());
                mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TaboolaWidget.this.resizeWidget(heightPx);
                    }
                }, 500L);
                return;
            }
            int actualHeightPx = heightPx;
            if (heightPx > sMaxWidgetSize) {
                actualHeightPx = sMaxWidgetSize;
                Logger.e(TAG, "Ad height exceeds max dimensions supported by the GPU. Using max available " + sMaxWidgetSize + " px");
            }
            if (heightPx > this.mWidgetMaxHeight) {
                actualHeightPx = this.mWidgetMaxHeight;
                Logger.e(TAG, "Ad height exceeds screen height. Using screen height" + this.mWidgetMaxHeight + " px");
                this.setScrollEnabled(true);
                this.mTaboolaWebView.setInterceptScroll(true);
            }
            if ((params = this.getLayoutParams()) != null) {
                params.height = actualHeightPx;
            } else {
                params = new ViewGroup.LayoutParams(-1, actualHeightPx);
            }
            this.setLayoutParams(params);
            Logger.d(TAG, "resized widget height to " + actualHeightPx + " px");
            this.postGlobalNotification("TABOOLA_VIEW_RESIZED", this, this.getHeight());
            if (this.getTaboolaEventListener() != null) {
                this.getTaboolaEventListener().taboolaViewResizeHandler(this, this.getHeight());
            }
            if (this.shouldCheckCacheSize && this.isCacheTooSmall(actualHeightPx) && Build.VERSION.SDK_INT >= 11) {
                this.mTaboolaWebView.setLayerType(0, null);
                this.shouldCheckCacheSize = false;
                this.fetchContent();
            }
        }
    }

    private boolean isCacheTooSmall(int heightPx) {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        long bmpSize = metrics.widthPixels * heightPx * 4;
        long maxCache = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumDrawingCacheSize();
        return bmpSize > maxCache;
    }

    private int dpToPx(int dp) {
        float density = this.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    private void bindCustomTabsService() {
        try {
            this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

                public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                    TaboolaWidget.this.mCustomTabsClient = client;
                    if (TaboolaWidget.this.mCustomTabsClient != null) {
                        TaboolaWidget.this.mCustomTabsClient.warmup(0L);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    TaboolaWidget.this.mCustomTabsClient = null;
                }
            };
            CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)CUSTOM_TAB_PACKAGE_NAME, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
        }
        catch (Exception e) {
            Logger.e(TAG, "bindCustomTabsService :: failed bind custom tab service : " + e.toString());
        }
    }

    private void unbindCustomTabsService() {
        if (this.mCustomTabsServiceConnection == null) {
            return;
        }
        if (this.isContextActivity) {
            try {
                this.getContext().unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
            }
            catch (Exception e) {
                Logger.e(TAG, "unbindCustomTabsService :: failed to unbind custom tab service : " + e.toString());
            }
        }
        this.mCustomTabsServiceConnection = null;
        this.mCustomTabsSession = null;
        this.mCustomTabsClient = null;
    }

    private CustomTabsSession getSession() {
        if (this.mCustomTabsClient == null) {
            this.mCustomTabsSession = null;
        } else if (this.mCustomTabsSession == null) {
            this.mCustomTabsSession = this.mCustomTabsClient.newSession(null);
        }
        return this.mCustomTabsSession;
    }

    private void onItemClick(String clickUrl, boolean isOrganic) {
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdClicked();
        }
        this.postGlobalNotification("TABOOLA_ITEM_DID_CLICK", this, null);
        if (this.isItemClickEnabled()) {
            boolean shouldHandleClick;
            boolean clickListenerRetVal = true;
            if (this.getTaboolaEventListener() != null) {
                clickListenerRetVal = this.getTaboolaEventListener().taboolaViewItemClickHandler(clickUrl, isOrganic);
            }
            if (!clickListenerRetVal) {
                if (this.shouldAllowNonOrganicClickOverride) {
                    shouldHandleClick = false;
                } else if (isOrganic) {
                    shouldHandleClick = false;
                } else {
                    shouldHandleClick = true;
                    Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
                }
            } else {
                shouldHandleClick = true;
            }
            if (shouldHandleClick) {
                this.openUrlInTabsOrBrowser(clickUrl);
            }
        } else {
            Logger.d(TAG, "ItemClickEnabled == false, performing default click action");
            this.openUrlInTabsOrBrowser(clickUrl);
        }
    }

    private void openUrlInTabsOrBrowser(String url) {
        try {
            if (this.isCustomTabsSupported && this.isContextActivity) {
                this.openChromeTab(url);
            } else {
                this.openNativeBrowser(url);
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "openUrlInTabsOrBrowser :: failed to open url " + e.toString());
        }
    }

    private void openChromeTab(String url) {
        if (this.isChromeTabLaunched) {
            return;
        }
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdOpened();
        }
        Logger.d(TAG, "openChromeTab :: opening ad in a ChromeTab");
        this.isChromeTabLaunched = true;
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.getSession());
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(this.getContext(), Uri.parse((String)url));
    }

    private void openNativeBrowser(String url) {
        if (this.mMediationEventListener != null) {
            this.mMediationEventListener.onAdLeftApplication();
        }
        Logger.d(TAG, "openNativeBrowser :: opening add");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        if (!this.isContextActivity) {
            intent.addFlags(0x10000000);
            Logger.d(TAG, "Widget is not using Activity context, so browser will be opened with Intent.FLAG_ACTIVITY_NEW_TASK flag");
        }
        this.getContext().startActivity(intent);
    }

    protected WebViewClient getWebViewClient() {
        WebViewClient webViewClient = new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                TaboolaWidget.this.dispatchLoadFailed(description);
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError error) {
                this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), req.getUrl().toString());
            }
        };
        Logger.d(TAG, "getWebViewClient :: initialized");
        return webViewClient;
    }

    protected WebChromeClient getWebChromeClient() {
        return new WebChromeClient(){
            private final String TAG = WebChromeClient.class.getSimpleName();

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Logger.d(this.TAG, "onJsAlert :: " + message);
                return super.onJsAlert(view, url, message, result);
            }

            public boolean onConsoleMessage(ConsoleMessage cm) {
                Log.d((String)this.TAG, (String)(cm.message() + ", source: " + cm.sourceId() + " From line " + cm.lineNumber()));
                return true;
            }
        };
    }

    public String getOptionalWidgetStyle() {
        return this.mWidgetStyle;
    }

    public TaboolaWidget setOptionalWidgetStyle(String newCSSStyle) {
        this.mWidgetStyle = newCSSStyle;
        return this;
    }

    public TaboolaWidget setMediatedVia(String mediatedVia) {
        this.mMediatedVia = mediatedVia;
        return this;
    }

    public boolean isScrollEnabled() {
        return this.mIsScrollEnabled;
    }

    public TaboolaWidget setScrollEnabled(boolean isScrollEnabled) {
        this.mIsScrollEnabled = isScrollEnabled;
        this.updateScrollBehaviour();
        return this;
    }

    public boolean isAutoResizeHeight() {
        return this.mIsAutoResizeHeight;
    }

    public TaboolaWidget setAutoResizeHeight(boolean shouldAutoResizeHeight) {
        this.mIsAutoResizeHeight = shouldAutoResizeHeight;
        return this;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public TaboolaWidget setPublisher(String newPub) {
        if (newPub != null && !newPub.isEmpty()) {
            this.mPublisher = newPub;
        }
        return this;
    }

    public TaboolaWidget setViewId(String viewID) {
        this.mViewID = viewID != null && !viewID.isEmpty() ? viewID : Long.toString(System.currentTimeMillis());
        return this;
    }

    public String getMode() {
        return this.mMode;
    }

    public TaboolaWidget setMode(String newMode) {
        if (newMode != null && !newMode.isEmpty()) {
            this.mMode = newMode;
        }
        return this;
    }

    public String getPlacement() {
        return this.mPlacement;
    }

    public TaboolaWidget setPlacement(String newPlacement) {
        if (newPlacement != null && !newPlacement.isEmpty()) {
            this.mPlacement = newPlacement;
        }
        return this;
    }

    public String getPageType() {
        return this.mPageType;
    }

    public TaboolaWidget setPageType(String newPageType) {
        if (newPageType != null && !newPageType.isEmpty()) {
            this.mPageType = newPageType;
        }
        return this;
    }

    public String getTargetType() {
        return this.mPageType;
    }

    public TaboolaWidget setTargetType(String newTargetType) {
        if (newTargetType != null && !newTargetType.isEmpty()) {
            this.mTargetType = newTargetType;
        }
        return this;
    }

    public String getPageUrl() {
        return this.mPageUrl;
    }

    public TaboolaWidget setPageUrl(String newPageUrl) {
        if (newPageUrl != null && !newPageUrl.isEmpty()) {
            this.mPageUrl = newPageUrl;
        }
        return this;
    }

    public String getPageId() {
        return this.mPageId;
    }

    public TaboolaWidget setPageId(String newPageId) {
        if (newPageId != null && !newPageId.isEmpty()) {
            this.mPageId = newPageId;
        }
        return this;
    }

    public TaboolaEventListener getTaboolaEventListener() {
        return this.mEventListener;
    }

    public TaboolaWidget setTaboolaEventListener(TaboolaEventListener newListener) {
        this.mEventListener = newListener;
        return this;
    }

    public TaboolaWidget setTaboolaDetectAdEventsListener(TaboolaDetectAdEventsListener newListener) {
        this.mTaboolaDetectAdEventsListener = newListener;
        return this;
    }

    public TaboolaWidget setMediationEventListener(MediationEventListener mediationEventListener) {
        this.mMediationEventListener = mediationEventListener;
        return this;
    }

    public void setLogLevel(int logLevel) {
        if (isSdkMonitorInstalled.booleanValue()) {
            Log.d((String)TAG, (String)"setLogLevel: setting debug level to DEBUG, because monitoring is enabled");
            Logger.setLogLevel(3);
        } else {
            Logger.setLogLevel(logLevel);
        }
    }

    public int getTextZoom() {
        if (this.mTaboolaWebView != null && Build.VERSION.SDK_INT >= 14) {
            return this.mTaboolaWebView.getSettings().getTextZoom();
        }
        return 100;
    }

    public TaboolaWidget setTextZoom(int textZoom) {
        if (this.mTaboolaWebView != null && Build.VERSION.SDK_INT >= 14) {
            this.mTaboolaWebView.getSettings().setTextZoom(textZoom);
        }
        return this;
    }

    @Deprecated
    public boolean isItemClickEnabled() {
        return this.mIsItemClickEnabled;
    }

    @Deprecated
    public void setItemClickEnabled(boolean mIsItemClickEnabled) {
        this.mIsItemClickEnabled = mIsItemClickEnabled;
    }

    public TaboolaWidget setOptionalPageCommands(HashMap<String, String> arrCommands) {
        String shouldAllow = arrCommands.get("allowNonOrganicClickOverride");
        if (shouldAllow != null) {
            arrCommands.remove("allowNonOrganicClickOverride");
            this.shouldAllowNonOrganicClickOverride = Boolean.parseBoolean(shouldAllow);
        }
        this.pushCommands(arrCommands);
        return this;
    }

    public TaboolaWidget setOptionalModeCommands(HashMap<String, String> arrCommands) {
        this.pushCommands(arrCommands);
        return this;
    }

    public void pushCommands(HashMap<String, String> arrCommands) {
        this.mCommands.add(arrCommands);
    }

    private void setDefValues() {
        this.mPublisher = "";
        this.mMode = "";
        this.mPlacement = "";
        this.mPageType = "";
        this.mTargetType = "mix";
        this.mPageId = "auto";
        this.mPageUrl = "";
        this.mWidgetStyle = "";
        this.mFramework = "mobile-sdk";
        this.mIsScrollEnabled = false;
        this.mIsItemClickEnabled = true;
        this.mIsAutoResizeHeight = true;
        Logger.d(TAG, "setDefValues :: initialize fields with default values");
    }

    private boolean hasMinimalAttributes() {
        return !TextUtils.isEmpty((CharSequence)this.mPublisher) && !TextUtils.isEmpty((CharSequence)this.mMode) && !TextUtils.isEmpty((CharSequence)this.mPlacement) && !TextUtils.isEmpty((CharSequence)this.mPageUrl) && !TextUtils.isEmpty((CharSequence)this.mPageType);
    }

    private void updateMaxWidgetSize() {
        Logger.d(TAG, "updateMaxWidgetSize :: called");
        if (sMaxWidgetSize == 0) {
            int size = GLHelper.getCachedMaxWidgetSize(this.getContext());
            if (size != 0) {
                sMaxWidgetSize = size;
            } else {
                GLHelper.getMaxWidgetSize(this, new GLHelper.onMaxWidgetSizeRetrievedCallback(){

                    @Override
                    public void onMaxWidgetSizeRetrieved(int size) {
                        sMaxWidgetSize = size;
                    }
                });
            }
        }
    }

    private void updateScrollBehaviour() {
        if (this.mIsScrollEnabled) {
            this.mTaboolaWebView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return false;
                }
            });
            this.mTaboolaWebView.setVerticalScrollBarEnabled(true);
        } else {
            this.mTaboolaWebView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return event.getAction() == 2;
                }
            });
            this.mTaboolaWebView.setVerticalScrollBarEnabled(false);
        }
        Logger.d(TAG, "updateScrollBehaviour :: scroll enabled " + this.mIsScrollEnabled);
    }

    private void stopInvalidationOnScrollEvents() {
        this.getViewTreeObserver().removeOnScrollChangedListener(this.mOnScrollChangedListener);
    }

    private void startInvalidationOnScrollEvents() {
        this.stopInvalidationOnScrollEvents();
        if (this.mInvalidationHandler == null) {
            this.mInvalidationHandler = new Handler();
        }
        long delayMillisShort = 500L;
        long delayMillisLong = 5000L;
        final Runnable shortScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.shouldIgnoreScrollEvents = false;
                TaboolaWidget.this.invalidateWebView();
            }
        };
        final Runnable longScrollRunnable = new Runnable(){

            @Override
            public void run() {
                TaboolaWidget.this.invalidateWebView();
            }
        };
        this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                if (!TaboolaWidget.this.shouldIgnoreScrollEvents) {
                    TaboolaWidget.this.shouldIgnoreScrollEvents = true;
                    if (TaboolaWidget.this.mInvalidationHandler != null) {
                        TaboolaWidget.this.mInvalidationHandler.postDelayed(shortScrollRunnable, 500L);
                        TaboolaWidget.this.mInvalidationHandler.postDelayed(longScrollRunnable, 5000L);
                    }
                }
            }
        };
        this.getViewTreeObserver().addOnScrollChangedListener(this.mOnScrollChangedListener);
    }

    public void invalidateWebView() {
        if (this.mTaboolaWebView != null) {
            this.mTaboolaWebView.post(new Runnable(){

                @Override
                public void run() {
                    if (TaboolaWidget.this.mTaboolaWebView != null) {
                        TaboolaWidget.this.mTaboolaWebView.invalidate();
                        Logger.v(TAG, "invalidateWebView executed");
                    }
                }
            });
        }
    }
}

