/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.api.TaboolaApiService;
import com.taboola.android.utils.Logger;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class RetrofitClient {
    private static final String BASE_URL = "http://api.taboola.com/1.2/json/";
    private static TaboolaApiService sTaboolaApiService;

    private RetrofitClient() {
    }

    static TaboolaApiService getTaboolaApiService(String publisherId) {
        Gson gson = new GsonBuilder().registerTypeAdapter(TBRecommendationsResponse.class, (Object)new RecommendationResponseAdapter()).create();
        if (sTaboolaApiService == null) {
            Retrofit retrofit = new Retrofit.Builder().client(RetrofitClient.buildOkHttpClient()).baseUrl(BASE_URL + publisherId + "/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
            sTaboolaApiService = (TaboolaApiService)retrofit.create(TaboolaApiService.class);
        }
        return sTaboolaApiService;
    }

    @NonNull
    private static OkHttpClient buildOkHttpClient() {
        try {
            String userAgent = System.getProperty("http.agent");
            if (userAgent != null && userAgent.length() > 0) {
                return new OkHttpClient.Builder().addInterceptor((Interceptor)new UserAgentInterceptor(userAgent)).build();
            }
        }
        catch (Exception e) {
            Logger.e(TaboolaApi.TAG, "Failed to build OkHttpClient with user agent interceptor: " + e.getLocalizedMessage());
        }
        return new OkHttpClient();
    }

    private static class UserAgentInterceptor
    implements Interceptor {
        private final String mUserAgent;

        public UserAgentInterceptor(String userAgent) {
            this.mUserAgent = userAgent;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", this.mUserAgent).build();
            return chain.proceed(requestWithUserAgent);
        }
    }

    private static class RecommendationItemAdapter
    implements JsonDeserializer<TBRecommendationItem> {
        private RecommendationItemAdapter() {
        }

        public TBRecommendationItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)gson.fromJson(json, TBRecommendationItem.class);
            JsonObject jsonObject = json.getAsJsonObject();
            if (!TaboolaApi.getInstance().isEnabledRawDataResponse()) {
                HashSet<String> rawDataKeys = new HashSet<String>();
                rawDataKeys.add("thumbnail");
                rawDataKeys.add("description");
                rawDataKeys.add("name");
                rawDataKeys.add("branding");
                for (String rawDataKey : rawDataKeys) {
                    jsonObject.remove(rawDataKey);
                }
            }
            HashSet<String> privateKeys = new HashSet<String>();
            privateKeys.add("origin");
            privateKeys.add("url");
            privateKeys.add("id");
            privateKeys.add("pixels");
            for (String privateKey : privateKeys) {
                jsonObject.remove(privateKey);
            }
            HashMap<String, String> extraDataMap = new HashMap<String, String>();
            for (Map.Entry elementJson : jsonObject.entrySet()) {
                extraDataMap.put((String)elementJson.getKey(), ((JsonElement)elementJson.getValue()).toString());
            }
            tbRecommendationItem.setExtraDataMap(extraDataMap);
            return tbRecommendationItem;
        }
    }

    private static class RecommendationResponseAdapter
    implements JsonDeserializer<TBRecommendationsResponse> {
        private RecommendationResponseAdapter() {
        }

        public TBRecommendationsResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Logger.d(TaboolaApi.TAG, "response json : " + json);
            TBRecommendationsResponse response = new TBRecommendationsResponse();
            HashMap<String, TBPlacement> placementMap = new HashMap<String, TBPlacement>();
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(TBRecommendationItem.class, (Object)new RecommendationItemAdapter()).create();
            for (Map.Entry elementJson : json.getAsJsonObject().entrySet()) {
                if (((String)elementJson.getKey()).equalsIgnoreCase("session")) {
                    String session = ((JsonElement)elementJson.getValue()).getAsString();
                    response.setSession(session);
                    continue;
                }
                TBPlacement placement = (TBPlacement)gson.fromJson((JsonElement)elementJson.getValue(), TBPlacement.class);
                for (TBRecommendationItem item : placement.getItems()) {
                    item.setPlacement(placement);
                }
                placementMap.put((String)elementJson.getKey(), placement);
            }
            response.setPlacementsMap(placementMap);
            return response;
        }
    }
}

