/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.os.Handler;
import android.view.View;
import android.view.ViewTreeObserver;
import com.taboola.android.api.TBImageView;
import com.taboola.android.api.TBTextView;
import com.taboola.android.api.TaboolaApi;

class SdkVisibilityCheckScheduler {
    private static final String TAG = SdkVisibilityCheckScheduler.class.getSimpleName();
    private static final int AFTER_SCROLL_CHECK_DELAY_MS = 300;
    private static final int RESCHEDULE_SCROLL_CHECK_STEP_MS = 100;
    private static final int STATIC_VISIBILITY_CHECK_STEP_MS = 400;
    private static final int STATIC_VISIBILITY_CHECK_TIMEOUT_MS = 5000;
    private View observedView;
    private Handler mVisibilityMonitoringHandler;
    private ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
    private Runnable mPerformOnScrollCheckRunnable;
    private Runnable performStaticCheckRunnable;
    private boolean isViewInScrollableParent = false;
    private long mLastScrollCheckRescheduleTimestamp = 0L;
    private long mStartStaticMonitoringTimestamp;

    SdkVisibilityCheckScheduler(View observedView) {
        this.observedView = observedView;
        this.mVisibilityMonitoringHandler = TaboolaApi.getInstance().getVisibilityMonitoringHandler();
    }

    void startVisibilityMonitoring() {
        this.startStaticMonitoring();
        this.startScrollMonitoring();
    }

    void stopVisibilityMonitoring() {
        this.stopScrollMonitoring();
        this.stopStaticMonitoring();
    }

    private void startStaticMonitoring() {
        this.stopStaticMonitoring();
        this.mStartStaticMonitoringTimestamp = System.currentTimeMillis();
        this.performStaticCheckRunnable = new Runnable(){

            @Override
            public void run() {
                boolean hasTimedOut;
                boolean bl = hasTimedOut = SdkVisibilityCheckScheduler.this.mStartStaticMonitoringTimestamp + 5000L > System.currentTimeMillis();
                if (!SdkVisibilityCheckScheduler.this.isViewInScrollableParent && !hasTimedOut && SdkVisibilityCheckScheduler.this.mVisibilityMonitoringHandler != null) {
                    SdkVisibilityCheckScheduler.this.mVisibilityMonitoringHandler.postDelayed(SdkVisibilityCheckScheduler.this.performStaticCheckRunnable, 400L);
                }
                SdkVisibilityCheckScheduler.this.performCheckOnView(SdkVisibilityCheckScheduler.this.observedView);
            }
        };
        this.mVisibilityMonitoringHandler.postDelayed(this.performStaticCheckRunnable, 400L);
    }

    private void stopStaticMonitoring() {
        this.mVisibilityMonitoringHandler.removeCallbacks(this.performStaticCheckRunnable);
    }

    private void startScrollMonitoring() {
        this.stopScrollMonitoring();
        this.mPerformOnScrollCheckRunnable = new Runnable(){

            @Override
            public void run() {
                SdkVisibilityCheckScheduler.this.performCheckOnView(SdkVisibilityCheckScheduler.this.observedView);
            }
        };
        this.onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                long currentTimeMillis = System.currentTimeMillis();
                if (SdkVisibilityCheckScheduler.this.mLastScrollCheckRescheduleTimestamp + 100L < currentTimeMillis) {
                    SdkVisibilityCheckScheduler.this.isViewInScrollableParent = true;
                    SdkVisibilityCheckScheduler.this.mLastScrollCheckRescheduleTimestamp = currentTimeMillis;
                    SdkVisibilityCheckScheduler.this.mVisibilityMonitoringHandler.removeCallbacks(SdkVisibilityCheckScheduler.this.mPerformOnScrollCheckRunnable);
                    SdkVisibilityCheckScheduler.this.mVisibilityMonitoringHandler.postDelayed(SdkVisibilityCheckScheduler.this.mPerformOnScrollCheckRunnable, 300L);
                }
            }
        };
        this.observedView.getViewTreeObserver().addOnScrollChangedListener(this.onScrollChangedListener);
    }

    private void stopScrollMonitoring() {
        this.observedView.getViewTreeObserver().removeOnScrollChangedListener(this.onScrollChangedListener);
        this.mVisibilityMonitoringHandler.removeCallbacks(this.mPerformOnScrollCheckRunnable);
    }

    private void performCheckOnView(View view) {
        if (this.observedView != null) {
            if (view instanceof TBImageView) {
                ((TBImageView)this.observedView).checkVisibility();
            } else if (view instanceof TBTextView) {
                ((TBTextView)this.observedView).checkVisibility();
            }
        }
    }
}

