/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TaboolaApi;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class TBPlacement
implements PublicApi.PublicTBPlacement,
Parcelable {
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="ui")
    @Expose
    private String ui;
    @SerializedName(value="variant")
    @Expose
    private String variant;
    private String mPlacementName;
    @SerializedName(value="list")
    @Expose
    private List<TBRecommendationItem> mRecommendationItems = new ArrayList<TBRecommendationItem>();
    private boolean hasReportedAvailability = false;
    private boolean hasReportedVisibility = false;
    private boolean mIsHighlighted = false;
    private TBRecommendationsRequest mNextBatchRequest;
    public static final Parcelable.Creator<TBPlacement> CREATOR = new Parcelable.Creator<TBPlacement>(){

        public TBPlacement createFromParcel(Parcel in) {
            return new TBPlacement(in);
        }

        public TBPlacement[] newArray(int size) {
            return new TBPlacement[size];
        }
    };

    protected TBPlacement(Parcel in) {
        this.id = in.readString();
        this.ui = in.readString();
        this.variant = in.readString();
        this.mPlacementName = in.readString();
        this.mRecommendationItems = in.createTypedArrayList(TBRecommendationItem.CREATOR);
        this.hasReportedAvailability = in.readByte() != 0;
        this.hasReportedVisibility = in.readByte() != 0;
        this.mIsHighlighted = in.readByte() != 0;
        this.mNextBatchRequest = (TBRecommendationsRequest)in.readParcelable(TBRecommendationsRequest.class.getClassLoader());
        for (TBRecommendationItem recommendationItem : this.mRecommendationItems) {
            recommendationItem.setPlacement(this);
        }
    }

    @Override
    public List<TBRecommendationItem> getItems() {
        return this.mRecommendationItems;
    }

    @Override
    public void prefetchThumbnails() {
        for (TBRecommendationItem item : this.mRecommendationItems) {
            item.prefetchThumbnail();
        }
    }

    public void notifyAvailable() {
        this.onItemAvailable();
    }

    public int getBatchId() {
        return this.mNextBatchRequest.getPlacementRequests().values().iterator().next().getBatchCounter() - 1;
    }

    void onItemAvailable() {
        if (!this.hasReportedAvailability) {
            this.hasReportedAvailability = true;
            TaboolaApi.getInstance().onPlacementAvailable(this.id);
            if (TaboolaApi.getInstance().isSdkMonitorInstalled().booleanValue()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        TaboolaApi.getInstance().getSdkMonitorManager().sendApiAvailable(TBPlacement.this.id);
                    }
                });
            }
        }
    }

    void onItemVisible() {
        if (!this.hasReportedVisibility) {
            this.hasReportedVisibility = true;
            TaboolaApi.getInstance().onPlacementVisible(this.id);
            if (TaboolaApi.getInstance().isSdkMonitorInstalled().booleanValue()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        TaboolaApi.getInstance().getSdkMonitorManager().sendApiVisible(TBPlacement.this.id);
                    }
                });
            }
        }
    }

    String getName() {
        return this.mPlacementName;
    }

    void setName(String name) {
        this.mPlacementName = name;
    }

    String getId() {
        return this.id;
    }

    void setHasReportedAvailability(boolean hasReportedAvailability) {
        this.hasReportedAvailability = hasReportedAvailability;
    }

    TBRecommendationsRequest getNextBatchRequest() {
        return this.mNextBatchRequest;
    }

    void setNextBatchRequest(TBRecommendationsRequest nextBatchRequest) {
        this.mNextBatchRequest = nextBatchRequest;
    }

    private boolean isHighlighted() {
        return this.mIsHighlighted;
    }

    private void setHighlighted(boolean isHighlighted) {
        this.mIsHighlighted = isHighlighted;
        for (TBRecommendationItem item : this.mRecommendationItems) {
            item.setHighlighted(this.mIsHighlighted);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.ui);
        dest.writeString(this.variant);
        dest.writeString(this.mPlacementName);
        dest.writeTypedList(this.mRecommendationItems);
        dest.writeByte((byte)(this.hasReportedAvailability ? 1 : 0));
        dest.writeByte((byte)(this.hasReportedVisibility ? 1 : 0));
        dest.writeByte((byte)(this.mIsHighlighted ? 1 : 0));
        dest.writeParcelable((Parcelable)this.mNextBatchRequest, flags);
    }

    static class ApiMonitorHandler
    extends Handler {
        private final WeakReference<TBPlacement> mPlacementWeakReference;

        ApiMonitorHandler(TBPlacement placement) {
            this.mPlacementWeakReference = new WeakReference<TBPlacement>(placement);
        }

        public void handleMessage(Message msg) {
            TBPlacement placement = (TBPlacement)this.mPlacementWeakReference.get();
            switch (msg.what) {
                case 291: {
                    if (placement == null) break;
                    placement.setHighlighted(!placement.isHighlighted());
                }
            }
        }
    }
}

