/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.TBImageView;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBTextView;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.utils.Logger;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TBRecommendationItem
implements PublicApi.PublicTBRecommendationItem,
Parcelable {
    private static final String TAG = TBRecommendationItem.class.getSimpleName();
    private HashMap<String, String> extraDataMap;
    @SerializedName(value="thumbnail")
    @Expose
    private List<Thumbnail> thumbnail = new ArrayList<Thumbnail>();
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="branding")
    @Expose
    private String branding;
    @SerializedName(value="description")
    @Expose
    private String description;
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="url")
    @Expose
    private String url;
    @SerializedName(value="type")
    @Expose
    private String type;
    @SerializedName(value="origin")
    @Expose
    private String origin;
    private long onVisibleTimestamp = 0L;
    private boolean wasRecommendationItemVisible = false;
    private transient WeakReference<TBImageView> mThumbnailView;
    private transient WeakReference<TBTextView> mTitleView;
    @Nullable
    private transient WeakReference<TBTextView> mBrandingView;
    @Nullable
    private transient WeakReference<TBTextView> mDescriptionView;
    private transient TBPlacement mPlacement;
    public static final Parcelable.Creator<TBRecommendationItem> CREATOR = new Parcelable.Creator<TBRecommendationItem>(){

        public TBRecommendationItem createFromParcel(Parcel in) {
            return new TBRecommendationItem(in);
        }

        public TBRecommendationItem[] newArray(int size) {
            return new TBRecommendationItem[size];
        }
    };

    protected TBRecommendationItem(Parcel in) {
        Bundle mapsBundle = in.readBundle();
        Serializable dataMap = mapsBundle.getSerializable("extraDataMap");
        this.extraDataMap = (HashMap)dataMap;
        this.thumbnail = in.createTypedArrayList(Thumbnail.CREATOR);
        this.name = in.readString();
        this.branding = in.readString();
        this.description = in.readString();
        this.id = in.readString();
        this.url = in.readString();
        this.type = in.readString();
        this.origin = in.readString();
        this.onVisibleTimestamp = in.readLong();
        this.wasRecommendationItemVisible = in.readByte() != 0;
    }

    @Override
    @NonNull
    public TBImageView getThumbnailView(Context activityContext) {
        if (this.mThumbnailView != null && this.mThumbnailView.get() != null) {
            return (TBImageView)this.mThumbnailView.get();
        }
        TBImageView tbImageView = new TBImageView(activityContext);
        TBPlacementRequest placementRequest = this.mPlacement.getNextBatchRequest().getPlacementRequests().values().iterator().next();
        int height = placementRequest.getThumbnailHeight();
        int width = placementRequest.getThumbnailWidth();
        if (height != 0 && width != 0) {
            tbImageView.setMinimumWidth(width);
            tbImageView.setMinimumHeight(height);
        }
        tbImageView.setAdjustViewBounds(true);
        tbImageView.setRecommendationItem(this);
        RequestCreator requestCreator = Picasso.with((Context)activityContext).load(this.thumbnail.get(0).getUrl());
        Drawable placeholder = TaboolaApi.getInstance().getImagePlaceholder();
        if (placeholder != null) {
            requestCreator.placeholder(placeholder);
        }
        requestCreator.into((ImageView)tbImageView);
        this.mThumbnailView = new WeakReference<TBImageView>(tbImageView);
        return tbImageView;
    }

    @Override
    @NonNull
    public TBTextView getTitleView(Context activityContext) {
        if (this.mTitleView != null && this.mTitleView.get() != null) {
            return (TBTextView)this.mTitleView.get();
        }
        TBTextView tbTextView = new TBTextView(activityContext);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.name);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(16.0f);
        tbTextView.setTextColor(-16777216);
        this.mTitleView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    @Nullable
    public TBTextView getBrandingView(Context activityContext) {
        if (this.mBrandingView != null && this.mBrandingView.get() != null) {
            return (TBTextView)this.mBrandingView.get();
        }
        if (TextUtils.isEmpty((CharSequence)this.branding)) {
            return null;
        }
        TBTextView tbTextView = new TBTextView(activityContext);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.branding);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(11.0f);
        tbTextView.setTextColor(Color.rgb((int)153, (int)153, (int)153));
        this.mBrandingView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    @Nullable
    public TBTextView getDescriptionView(Context activityContext) {
        if (this.mDescriptionView != null && this.mDescriptionView.get() != null) {
            return (TBTextView)this.mDescriptionView.get();
        }
        if (TextUtils.isEmpty((CharSequence)this.description)) {
            return null;
        }
        TBTextView tbTextView = new TBTextView(activityContext);
        tbTextView.setRecommendationItem(this);
        tbTextView.setText(this.description);
        tbTextView.setTypeface(Typeface.SANS_SERIF, 1);
        tbTextView.setTextSize(11.0f);
        tbTextView.setTextColor(Color.rgb((int)153, (int)153, (int)153));
        this.mDescriptionView = new WeakReference<TBTextView>(tbTextView);
        return tbTextView;
    }

    @Override
    public void prefetchThumbnail() {
        Picasso.with((Context)TaboolaApi.getInstance().getApplicationContext()).load(this.thumbnail.get(0).getUrl()).fetch();
    }

    @Override
    public void handleClick(Context activityContext) {
        TaboolaApi.getInstance().onItemClick(activityContext, this.mPlacement.getName(), this.mPlacement.getId(), this.id, this.url, this.isOrganic(), this.type);
    }

    public HashMap<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    public void notifyAvailable() {
        this.onViewAvailable();
    }

    public void notifyVisible() {
        this.onViewVisible();
    }

    public TBPlacement getPlacement() {
        return this.mPlacement;
    }

    void onViewAvailable() {
        this.mPlacement.onItemAvailable();
    }

    void onViewVisible() {
        Logger.d(TAG, "RecommendationItemVisible: " + this.id);
        if (this.onVisibleTimestamp == 0L) {
            this.onVisibleTimestamp = System.currentTimeMillis();
        }
        this.wasRecommendationItemVisible = true;
        this.mPlacement.onItemVisible();
        this.stopVisibilityCheck();
    }

    void onViewClick(Context context) {
        if (!this.wasRecommendationItemVisible) {
            Logger.d(TAG, "onViewClick: click ignored, because item is not considered visible");
            return;
        }
        int onClickIgnoreTimeMs = TaboolaApi.getInstance().getOnClickIgnoreTimeMs();
        if (this.onVisibleTimestamp + (long)onClickIgnoreTimeMs < System.currentTimeMillis()) {
            TaboolaApi.getInstance().onItemClick(context, this.mPlacement.getName(), this.mPlacement.getId(), this.id, this.url, this.isOrganic(), this.type);
        } else {
            Logger.d(TAG, "onViewClick: click ignored, because item was visible for less than " + onClickIgnoreTimeMs + " ms");
        }
    }

    private void stopVisibilityCheck() {
        if (this.mThumbnailView != null && this.mThumbnailView.get() != null) {
            ((TBImageView)this.mThumbnailView.get()).stopVisibilityCheck();
        }
        if (this.mTitleView != null && this.mTitleView.get() != null) {
            ((TBTextView)this.mTitleView.get()).stopVisibilityCheck();
        }
        if (this.mBrandingView != null && this.mBrandingView.get() != null) {
            ((TBTextView)this.mBrandingView.get()).stopVisibilityCheck();
        }
        if (this.mDescriptionView != null && this.mDescriptionView.get() != null) {
            ((TBTextView)this.mDescriptionView.get()).stopVisibilityCheck();
        }
    }

    void setPlacement(TBPlacement placement) {
        this.mPlacement = placement;
    }

    void setExtraDataMap(HashMap<String, String> extraDataMap) {
        this.extraDataMap = extraDataMap;
    }

    boolean isOrganic() {
        return "organic".equalsIgnoreCase(this.origin);
    }

    void setHighlighted(boolean isHighlighted) {
        int newBackground = isHighlighted ? -16711936 : 0;
        TBImageView imageView = (TBImageView)this.mThumbnailView.get();
        TBTextView titleView = (TBTextView)this.mTitleView.get();
        TBTextView brandingView = (TBTextView)this.mBrandingView.get();
        if (imageView != null) {
            imageView.setBackgroundColor(newBackground);
        }
        if (titleView != null) {
            titleView.setBackgroundColor(newBackground);
        }
        if (brandingView != null) {
            brandingView.setBackgroundColor(newBackground);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle mapsBundle = new Bundle();
        mapsBundle.putSerializable("extraDataMap", this.extraDataMap);
        dest.writeBundle(mapsBundle);
        dest.writeTypedList(this.thumbnail);
        dest.writeString(this.name);
        dest.writeString(this.branding);
        dest.writeString(this.description);
        dest.writeString(this.id);
        dest.writeString(this.url);
        dest.writeString(this.type);
        dest.writeString(this.origin);
        dest.writeLong(this.onVisibleTimestamp);
        dest.writeByte((byte)(this.wasRecommendationItemVisible ? 1 : 0));
    }

    private static class Thumbnail
    implements Parcelable {
        @SerializedName(value="url")
        @Expose
        private String url;
        public static final Parcelable.Creator<Thumbnail> CREATOR = new Parcelable.Creator<Thumbnail>(){

            public Thumbnail createFromParcel(Parcel in) {
                return new Thumbnail(in);
            }

            public Thumbnail[] newArray(int size) {
                return new Thumbnail[size];
            }
        };

        protected Thumbnail(Parcel in) {
            this.url = in.readString();
        }

        String getUrl() {
            return this.url;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.url);
        }
    }
}

