/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Nullable;
import com.taboola.android.MonitorManager;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.RetrofitClient;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApiService;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.api.TestHelperInternal;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PopupHelper;
import com.taboola.android.utils.RequestUtil;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SharedPrefUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TaboolaApi
implements PublicApi.PublicTaboolaApi {
    static final String TAG = TaboolaApi.class.getSimpleName();
    private static final String REQUEST_ID_KEY = "req_id";
    private final Object mUserSessionLock = new Object();
    private int onClickIgnoreTimeMs = 300;
    private boolean mIsSdkMonitorInstalled;
    private MonitorManager mSdkMonitorManager = null;
    @Nullable
    private String mAdvertisingId = null;
    private Context mApplicationContext;
    private String mPublisherId;
    private String apiKey;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private boolean mIsEnabledRawDataResponse = false;
    private TaboolaApiService mTaboolaApiService;
    private Handler mVisibilityMonitoringHandler = new Handler();
    private Map<String, TBRecommendationsRequest> mRequestMap = new HashMap<String, TBRecommendationsRequest>();
    private Drawable mImagePlaceholderDrawable;
    private TaboolaOnClickListener mOnClickListener;
    private TestHelperInternal.SdkEventsTestListener mSdkEventsTestListener;
    private static final TaboolaApi ourInstance = new TaboolaApi();

    public static TaboolaApi getInstance() {
        return ourInstance;
    }

    private TaboolaApi() {
    }

    @Override
    public TaboolaApi init(Context applicationContext, String publisherId, String apiKey) {
        this.mApplicationContext = applicationContext.getApplicationContext();
        this.mPublisherId = publisherId;
        this.apiKey = apiKey;
        if (this.mAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(applicationContext);
        }
        this.mTaboolaApiService = RetrofitClient.getTaboolaApiService(publisherId);
        this.mIsSdkMonitorInstalled = MonitorUtils.isSdkMonitorInstalled(this.mApplicationContext);
        if (this.mIsSdkMonitorInstalled) {
            this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(this.mApplicationContext));
            this.mSdkMonitorManager.bindService(this.mApplicationContext);
            Logger.setSdkMonitorManager(this.mSdkMonitorManager);
        }
        return this;
    }

    @Override
    public void fetchRecommendations(TBRecommendationsRequest request, TBRecommendationRequestCallback callback) {
        request.setUserSession(this.getUserSession());
        request.setAppType("mobile");
        request.setApiKey(this.apiKey);
        request.setAppName(SdkDetailsHelper.getApplicationName(this.mApplicationContext));
        request.setViewId(String.valueOf(System.currentTimeMillis()));
        String additionalData = SdkDetailsHelper.createSdkJsonString(this.mApplicationContext, null, "Taboola Android SDK - API");
        request.setAdditionalData(additionalData);
        this.waitForAdvertisingIdAndFetchRecommendations(request, callback);
    }

    @Override
    public void getNextBatchForPlacement(TBPlacement placement, TBRecommendationRequestCallback callback) {
        this.getNextBatchForPlacement(placement, 0, callback);
    }

    @Override
    public void getNextBatchForPlacement(TBPlacement placement, int count, TBRecommendationRequestCallback callback) {
        TBRecommendationsRequest nextBatchRequest = placement.getNextBatchRequest();
        nextBatchRequest.setUserSession(this.getUserSession());
        if (count > 0) {
            TBPlacementRequest placementRequest = nextBatchRequest.getPlacementRequests().values().iterator().next();
            placementRequest.setRecCount(count);
        }
        this.actuallyFetchRecommendations(nextBatchRequest, callback);
    }

    @Override
    public void handleAttributionClick(Context activityContext) {
        if (!(activityContext instanceof Activity)) {
            Logger.e(TAG, "Attribution dialog can be showed only using Activity Context");
            throw new IllegalArgumentException("Activity context expected");
        }
        String locale = activityContext.getResources().getConfiguration().locale.getCountry();
        String url = "https://popup.taboola.com/" + locale;
        if (!PopupHelper.openPopup(activityContext, url)) {
            Logger.d(TAG, "failed to open popup, so opening browser");
            OnClickHelper.openUrlInTabsOrBrowser(activityContext, url);
        }
    }

    @Override
    public TaboolaApi setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    @Override
    public TaboolaApi setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.onClickIgnoreTimeMs = onClickIgnoreTimeMs;
        return this;
    }

    @Override
    public TaboolaApi setLogLevel(int logLevel) {
        if (this.mIsSdkMonitorInstalled) {
            Logger.setLogLevel(3);
            return this;
        }
        Logger.setLogLevel(logLevel);
        return this;
    }

    @Override
    public TaboolaApi setImagePlaceholder(Drawable placeholderDrawable) {
        this.mImagePlaceholderDrawable = placeholderDrawable;
        return this;
    }

    public TaboolaApi setExtraProperties(Map<String, String> extraProperties) {
        this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(extraProperties.get("allowNonOrganicClickOverride"));
        this.mIsEnabledRawDataResponse = Boolean.parseBoolean(extraProperties.get("enabledRawDataResponse"));
        return this;
    }

    void setSdkEventsTestListener(TestHelperInternal.SdkEventsTestListener sdkEventsTestListener) {
        this.mSdkEventsTestListener = sdkEventsTestListener;
    }

    Drawable getImagePlaceholder() {
        return this.mImagePlaceholderDrawable;
    }

    void onPlacementAvailable(String responseId) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onAvailable();
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("response.id", responseId);
        queryParameters.put("response.session", this.getUserSession());
        queryParameters.put("app.type", "mobile");
        queryParameters.put("app.apikey", this.apiKey);
        this.mTaboolaApiService.notifyAvailable(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.isSuccessful()) {
                    Logger.d(TAG, "onPlacementAvailable notification successfully sent");
                } else {
                    Logger.e(TAG, "onPlacementAvailable notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                Logger.e(TAG, "onPlacementAvailable notification failed " + t.getMessage());
            }
        });
    }

    void onPlacementVisible(String responseId) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onVisible();
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("response.id", responseId);
        queryParameters.put("response.session", this.getUserSession());
        queryParameters.put("app.type", "mobile");
        queryParameters.put("app.apikey", this.apiKey);
        this.mTaboolaApiService.notifyVisible(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.isSuccessful()) {
                    Logger.d(TAG, "onPlacementVisible notification successfully sent");
                } else {
                    Logger.e(TAG, "onPlacementVisible notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                Logger.e(TAG, "onPlacementVisible notification failed " + t.getMessage());
            }
        });
    }

    void onItemClick(Context activityContext, String placementName, String placementId, String itemId, String clickUrl, boolean isOrganic, String itemType) {
        if (this.mIsSdkMonitorInstalled) {
            this.mSdkMonitorManager.sendApiClicked(placementId);
        }
        RequestUtil.performPreClickCallAsync(activityContext, this.mPublisherId, clickUrl, "Taboola Android SDK - API");
        boolean shouldSdkHandleClick = true;
        if (this.mOnClickListener != null) {
            shouldSdkHandleClick = this.mOnClickListener.onItemClick(placementName, itemId, clickUrl, isOrganic);
        }
        if (shouldSdkHandleClick) {
            OnClickHelper.openUrlInTabsOrBrowser(activityContext, clickUrl);
        } else if (isOrganic || this.mShouldAllowNonOrganicClickOverride) {
            this.notifyClick(placementId, itemType, itemId);
        } else {
            Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
            OnClickHelper.openUrlInTabsOrBrowser(activityContext, clickUrl);
        }
    }

    int getOnClickIgnoreTimeMs() {
        return this.onClickIgnoreTimeMs;
    }

    Handler getVisibilityMonitoringHandler() {
        return this.mVisibilityMonitoringHandler;
    }

    boolean isEnabledRawDataResponse() {
        return this.mIsEnabledRawDataResponse;
    }

    Context getApplicationContext() {
        return this.mApplicationContext;
    }

    private void notifyClick(String placementId, String itemType, String itemId) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("response.id", placementId);
        queryParameters.put("response.session", this.getUserSession());
        queryParameters.put("app.type", "mobile");
        queryParameters.put("app.apikey", this.apiKey);
        queryParameters.put("item.type", itemType);
        queryParameters.put("item.id", itemId);
        this.mTaboolaApiService.notifyClick(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.isSuccessful()) {
                    Logger.d(TAG, "onItemClick notification successfully sent");
                } else {
                    Logger.e(TAG, "onItemClick notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                Logger.e(TAG, "onItemClick notification failed " + t.getMessage());
            }
        });
    }

    private void waitForAdvertisingIdAndFetchRecommendations(final TBRecommendationsRequest request, final TBRecommendationRequestCallback listener) {
        if (this.mAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(this.mApplicationContext);
            if (cachedId != null) {
                this.mAdvertisingId = cachedId;
                request.setDeviceId(this.mAdvertisingId);
                this.actuallyFetchRecommendations(request, listener);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(this.mApplicationContext, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        TaboolaApi.this.mAdvertisingId = advertisingId;
                        request.setDeviceId(TaboolaApi.this.mAdvertisingId);
                        TaboolaApi.this.actuallyFetchRecommendations(request, listener);
                    }

                    @Override
                    public void onIdUnavailable() {
                        TaboolaApi.this.mAdvertisingId = "";
                        TaboolaApi.this.actuallyFetchRecommendations(request, listener);
                    }
                });
            }
        } else if (this.mAdvertisingId.isEmpty()) {
            this.actuallyFetchRecommendations(request, listener);
        } else if (!this.mAdvertisingId.isEmpty()) {
            request.setDeviceId(this.mAdvertisingId);
            this.actuallyFetchRecommendations(request, listener);
        }
    }

    private void actuallyFetchRecommendations(TBRecommendationsRequest request, final TBRecommendationRequestCallback listener) {
        String requestUuid = UUID.randomUUID().toString();
        this.mRequestMap.put(requestUuid, request);
        HashMap<String, String> queryParameters = request.generateQueryParameters();
        queryParameters.put(REQUEST_ID_KEY, requestUuid);
        Callback<TBRecommendationsResponse> responseCallback = new Callback<TBRecommendationsResponse>(){

            public void onResponse(Call<TBRecommendationsResponse> call, Response<TBRecommendationsResponse> response) {
                Logger.d(TAG, "request URL : " + call.request().url());
                if (response.isSuccessful()) {
                    try {
                        TaboolaApi.this.onSuccessfulResponse((Call<TBRecommendationsResponse>)call, (Response<TBRecommendationsResponse>)response, listener);
                    }
                    catch (Exception e) {
                        listener.onRecommendationsFailed(new Throwable(e.getMessage()));
                    }
                } else {
                    listener.onRecommendationsFailed(new Throwable(response.message()));
                }
            }

            public void onFailure(Call<TBRecommendationsResponse> call, Throwable t) {
                listener.onRecommendationsFailed(t);
            }
        };
        this.mTaboolaApiService.fetchRecommendations(queryParameters).enqueue((Callback)responseCallback);
    }

    private void onSuccessfulResponse(Call<TBRecommendationsResponse> call, Response<TBRecommendationsResponse> response, TBRecommendationRequestCallback listener) {
        String reqId = call.request().url().queryParameter(REQUEST_ID_KEY);
        final TBRecommendationsRequest request = this.mRequestMap.get(reqId);
        this.mRequestMap.remove(reqId);
        TBRecommendationsResponse body = (TBRecommendationsResponse)response.body();
        for (Map.Entry<String, TBPlacement> placementEntry : body.getPlacementsMap().entrySet()) {
            final TBPlacement placementValue = placementEntry.getValue();
            TBPlacementRequest tbPlacementRequest = request.getPlacementRequests().get(placementEntry.getKey());
            if (tbPlacementRequest == null) {
                tbPlacementRequest = request.getPlacementRequests().values().iterator().next();
            }
            boolean isAvailable = tbPlacementRequest.getAvailable();
            placementValue.setHasReportedAvailability(isAvailable);
            TBRecommendationsRequest nextBatchRequest = request.createNextBatchRequest(placementEntry.getKey());
            placementValue.setNextBatchRequest(nextBatchRequest);
            placementValue.setName(placementEntry.getKey());
            if (!this.mIsSdkMonitorInstalled) continue;
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Messenger placementMessenger = new Messenger((Handler)new TBPlacement.ApiMonitorHandler(placementValue));
                    TaboolaApi.this.mSdkMonitorManager.sendApiReceived(placementValue.getId(), placementValue.getName(), placementMessenger);
                    TaboolaApi.this.mSdkMonitorManager.sendApiProperties(placementValue.getId(), request.generateQueryParameters());
                }
            });
        }
        this.setUserSession(body.getSession());
        listener.onRecommendationsFetched(body);
    }

    Boolean isSdkMonitorInstalled() {
        return this.mIsSdkMonitorInstalled;
    }

    MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserSession() {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            return SharedPrefUtil.getUserSession(this.mApplicationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserSession(String userSession) {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            SharedPrefUtil.setUserSession(this.mApplicationContext, userSession);
            SharedPrefUtil.setUserSessionTimestamp(this.mApplicationContext, System.currentTimeMillis());
        }
    }
}

