/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.WebView;
import com.taboola.android.MonitorManager;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.PublicApi;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.util.HashMap;
import java.util.Map;

public class TaboolaJs
implements PublicApi.PublicTaboolaJs {
    public static final String INJECTED_OBJECT_NAME = "taboolaNative";
    private static final String TAG = TaboolaJs.class.getSimpleName();
    @Nullable
    private static String sAdvertisingId = null;
    private static final TaboolaJs ourInstance = new TaboolaJs();
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private Context mApplicationContext;
    @Nullable
    private TaboolaOnClickListener mOnClickListener;
    private Map<WebView, WebViewManager> mWebViewManagers = new HashMap<WebView, WebViewManager>();
    private MonitorManager mSdkMonitorManager = null;
    private boolean mIsSdkMonitorInstalled = false;

    private TaboolaJs() {
    }

    public static TaboolaJs getInstance() {
        return ourInstance;
    }

    @Override
    public TaboolaJs init(@NonNull Context applicationContext) {
        this.mApplicationContext = applicationContext.getApplicationContext();
        if (sAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(this.mApplicationContext);
        }
        this.mIsSdkMonitorInstalled = MonitorUtils.isSdkMonitorInstalled(this.mApplicationContext);
        if (this.mIsSdkMonitorInstalled) {
            this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(this.mApplicationContext));
            this.mSdkMonitorManager.bindService(this.mApplicationContext);
            Logger.setSdkMonitorManager(this.mSdkMonitorManager);
        }
        return this;
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView) {
        this.registerWebView(webView, null);
        return this;
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        if (this.mWebViewManagers.containsKey(webView)) {
            Logger.e(TAG, "registerWebView: WebView is already registered");
        } else {
            WebViewManager webViewManager = new WebViewManager(webView);
            webViewManager.setOnRenderListener(onRenderListener);
            this.mWebViewManagers.put(webView, webViewManager);
            webViewManager.registerWebView();
        }
        return this;
    }

    @Override
    public TaboolaJs unregisterWebView(@NonNull WebView webView) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            Logger.e(TAG, "unregisterWebView: WebView is not registered");
        } else {
            webViewManager.unregisterWebView();
            this.mWebViewManagers.remove(webView);
        }
        return this;
    }

    @Override
    public TaboolaJs setLogLevel(int logLevel) {
        Logger.setLogLevel(logLevel);
        return this;
    }

    @Override
    public TaboolaJs setOnRenderListener(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnRenderListener(onRenderListener);
        } else {
            Logger.e(TAG, "setOnRenderListener: WebView is not registered");
        }
        return this;
    }

    public TaboolaJs setOnResizeListener(@NonNull WebView webView, @Nullable OnResizeListener onResizeListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnResizeListener(onResizeListener);
        } else {
            Logger.e(TAG, "setOnResizeListener: WebView is not registered");
        }
        return this;
    }

    @Override
    public TaboolaJs setOnClickListener(@Nullable TaboolaOnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull Map<String, String> extraProperties) {
        this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(extraProperties.get("allowNonOrganicClickOverride"));
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull WebView webView, @NonNull Map<String, String> extraProperties) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setExtraProperties(extraProperties);
        } else {
            Logger.e(TAG, "setExtraProperties: WebView is not registered");
        }
        return this;
    }

    boolean shouldAllowNonOrganicClickOverride() {
        return this.mShouldAllowNonOrganicClickOverride;
    }

    @Nullable
    TaboolaOnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    @Nullable
    String getAdvertisingIdFromMemory() {
        return sAdvertisingId;
    }

    void getAdvertisingId(final AdvertisingIdRetrievedCallback callback) {
        if (sAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(this.mApplicationContext);
            if (cachedId != null) {
                sAdvertisingId = cachedId;
                callback.onAdIdRetrieved(sAdvertisingId);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(this.mApplicationContext, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        sAdvertisingId = advertisingId;
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }

                    @Override
                    public void onIdUnavailable() {
                        sAdvertisingId = "";
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }
                });
            }
        } else if (sAdvertisingId.isEmpty()) {
            callback.onAdIdRetrieved(sAdvertisingId);
        } else if (!sAdvertisingId.isEmpty()) {
            callback.onAdIdRetrieved(sAdvertisingId);
        }
    }

    boolean isSdkMonitorInstalled() {
        return this.mIsSdkMonitorInstalled;
    }

    public MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    static interface AdvertisingIdRetrievedCallback {
        public void onAdIdRetrieved(String var1);
    }
}

