/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.mediation;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.taboola.android.TaboolaWidget;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MediationUtils;
import java.util.HashMap;

public class DfpCustomEventBanner
implements CustomEventBanner,
MediationEventListener {
    private static final String TAG = DfpCustomEventBanner.class.getSimpleName();
    private static final String MEDIATED_VIA_VALUE_DFP = "dfp";
    private CustomEventBannerListener mCustomEventBannerListener;
    private LinearLayout mTaboolaContainer;

    public void requestBannerAd(Context context, CustomEventBannerListener customEventBannerListener, String s, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle) {
        Logger.d(TAG, "requestBannerAd :: creating ad view");
        this.mCustomEventBannerListener = customEventBannerListener;
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                String value = bundle.getString(key);
                if (value == null) continue;
                mergedProperties.put(key, value);
            }
        } else {
            Logger.d(TAG, "requestBannerAd :: Bundle is null");
        }
        MediationUtils.parseJsonToProperties(s, mergedProperties);
        TaboolaWidget taboolaWidget = new TaboolaWidget(context);
        taboolaWidget.setMediationEventListener(this);
        taboolaWidget.setMediatedVia(MEDIATED_VIA_VALUE_DFP);
        MediationUtils.fillProperties(taboolaWidget, mergedProperties);
        taboolaWidget.pushCommands(mergedProperties);
        taboolaWidget.fetchContent();
        Logger.d(TAG, "requestBannerAd :: ad view created, waiting to load");
        this.mTaboolaContainer = new LinearLayout(context);
        this.mTaboolaContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mTaboolaContainer.addView((View)taboolaWidget);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onDestroy() {
    }

    @Override
    public void onAdLoaded() {
        Logger.d(TAG, "ad successfully loaded");
        this.mCustomEventBannerListener.onAdLoaded((View)this.mTaboolaContainer);
    }

    @Override
    public void onAdFailedToLoad(String reason) {
        Logger.e(TAG, "Failed to load Taboola ad. reason: " + reason);
        this.mCustomEventBannerListener.onAdFailedToLoad(-1);
    }

    @Override
    public void onAdClicked() {
        this.mCustomEventBannerListener.onAdClicked();
    }

    @Override
    public void onAdOpened() {
        this.mCustomEventBannerListener.onAdOpened();
    }

    @Override
    public void onAdClosed() {
        this.mCustomEventBannerListener.onAdClosed();
    }

    @Override
    public void onAdLeftApplication() {
        this.mCustomEventBannerListener.onAdLeftApplication();
    }
}

