/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.mediation;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import com.taboola.android.TaboolaWidget;
import com.taboola.android.listeners.MediationEventListener;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MediationUtils;
import java.util.HashMap;
import java.util.Map;

public class MoPubCustomEventBanner
extends CustomEventBanner
implements MediationEventListener {
    private static final String TAG = MoPubCustomEventBanner.class.getSimpleName();
    private static final String MEDIATED_VIA_VALUE_MOPUB = "mopub";
    private static final String[] IGNORED_PARAMETERS = new String[]{"Clickthrough-Url", "mopub-intent-ad-report", "com_mopub_ad_width", "com_mopub_ad_height", "broadcastIdentifier"};
    private CustomEventBanner.CustomEventBannerListener mCustomEventBannerListener;
    private LinearLayout mTaboolaContainer;

    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Logger.d(TAG, "loadBanner :: creating ad view");
        this.mCustomEventBannerListener = customEventBannerListener;
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        for (String key : localExtras.keySet()) {
            Object localValue = localExtras.get(key);
            if (localValue == null) continue;
            mergedProperties.put(key, localValue.toString());
        }
        for (String key : serverExtras.keySet()) {
            String serverValue = serverExtras.get(key);
            if (serverValue == null) continue;
            mergedProperties.put(key, serverValue);
        }
        for (String s : IGNORED_PARAMETERS) {
            mergedProperties.remove(s);
        }
        TaboolaWidget taboolaWidget = new TaboolaWidget(context);
        taboolaWidget.setMediationEventListener(this);
        taboolaWidget.setMediatedVia(MEDIATED_VIA_VALUE_MOPUB);
        MediationUtils.fillProperties(taboolaWidget, mergedProperties);
        taboolaWidget.pushCommands(mergedProperties);
        taboolaWidget.fetchContent();
        Logger.d(TAG, "loadBanner :: ad view created, waiting to load");
        this.mTaboolaContainer = new LinearLayout(context);
        this.mTaboolaContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mTaboolaContainer.addView((View)taboolaWidget);
    }

    protected void onInvalidate() {
    }

    @Override
    public void onAdLoaded() {
        Logger.d(TAG, "ad successfully loaded");
        this.mCustomEventBannerListener.onBannerLoaded((View)this.mTaboolaContainer);
    }

    @Override
    public void onAdFailedToLoad(String reason) {
        Logger.e(TAG, "Failed to load Taboola ad. reason: " + reason);
        this.mCustomEventBannerListener.onBannerFailed(MoPubErrorCode.UNSPECIFIED);
    }

    @Override
    public void onAdClicked() {
        this.mCustomEventBannerListener.onBannerClicked();
    }

    @Override
    public void onAdOpened() {
        this.mCustomEventBannerListener.onBannerExpanded();
    }

    @Override
    public void onAdClosed() {
        this.mCustomEventBannerListener.onBannerCollapsed();
    }

    @Override
    public void onAdLeftApplication() {
        this.mCustomEventBannerListener.onLeaveApplication();
    }
}

