/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Build;
import android.support.v4.widget.ContentLoadingProgressBar;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import com.taboola.android.R;
import com.taboola.android.utils.Logger;

public class PopupHelper {
    private static final String TAG = PopupHelper.class.getSimpleName();

    public static boolean openPopup(Context context, String url) {
        try {
            Activity activity = (Activity)context;
            View webLayout = activity.getLayoutInflater().inflate(R.layout.dialog_web, null);
            final AlertDialog alertDialog = new AlertDialog.Builder(context).setView(webLayout).create();
            alertDialog.show();
            ImageButton imageButton = (ImageButton)webLayout.findViewById(R.id.web_dialog_dismiss_button);
            imageButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    alertDialog.dismiss();
                }
            });
            final ContentLoadingProgressBar progressBar = (ContentLoadingProgressBar)webLayout.findViewById(R.id.web_dialog_progress_bar);
            WebView webView = (WebView)webLayout.findViewById(R.id.web_dialog_web_view);
            webView.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    progressBar.hide();
                }
            });
            webView.getSettings().setJavaScriptEnabled(true);
            webView.getSettings().setBuiltInZoomControls(true);
            CookieManager.getInstance().setAcceptCookie(true);
            if (Build.VERSION.SDK_INT >= 21) {
                CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
            }
            webView.loadUrl(url);
            return true;
        }
        catch (ClassCastException | NullPointerException e) {
            Logger.e(TAG, "Can't show popup");
            e.printStackTrace();
            return false;
        }
    }
}

