/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.LocaleList;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.ScrollView;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkDetailsHelper {
    private static final String TAG = SdkDetailsHelper.class.getSimpleName();
    private static final String SDK_DATA = "sdkd";
    private static final String SDK_TYPE = "sdkt";
    private static final String SDK_VERSION = "sdkv";
    private static final String APP_NAME = "app";
    private static final String APP_VERSION = "appv";
    private static final String APP_ID = "appid";
    private static final String DEVICE_MODEL = "model";
    private static final String LANGUAGES_ROOT = "lng";
    private static final String PREFERRED_LANGUAGES = "kbd";
    private static final String MAIN_LANGUAGE = "main";
    private static final String OS = "os";
    private static final String OS_VERSION = "osv";
    private static final String MEDIATED_VIA = "mdtd";
    private static final String NETWORK_TYPE = "net";
    private static final String SCREEN_SIZE = "scr";
    private static final String WIDTH = "wd";
    private static final String HEIGHT = "ht";
    private static final String LOCATION = "loc";
    private static final String LAT = "lat";
    private static final String LON = "lng";
    private static final String ROOT_KEY = "additional_data";
    private static final String NT_2G = "2g";
    private static final String NT_3G = "3g";
    private static final String NT_4G = "4g";
    private static final String NT_WIFI = "wifi";
    public static final String SDK_TYPE_WIDGET = "Taboola Android SDK";
    public static final String SDK_TYPE_API = "Taboola Android SDK - API";
    public static final String SDK_TYPE_JS = "Taboola Android SDK - JS";
    private static final String ANDROID = "Android";
    private static String sApplicationName;

    private SdkDetailsHelper() {
    }

    static String getDefaultBrowser(Context applicationContext) {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://"));
        ResolveInfo resolveInfo = applicationContext.getPackageManager().resolveActivity(browserIntent, 65536);
        return resolveInfo.loadLabel(applicationContext.getPackageManager()).toString();
    }

    public static HashMap<String, String> createSdkDetailsMap(Context context, @Nullable String mediatedVia, String sdkType) {
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put(ROOT_KEY, SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).toString());
        return detailsMap;
    }

    public static String createSdkJsonString(Context context, @Nullable String mediatedVia, String sdkType) {
        return SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).toString();
    }

    @SuppressLint(value={"MissingPermission"})
    public static JSONObject createSdkDetailsJSON(Context context, @Nullable String mediatedVia, String sdkType) {
        JSONObject sdkDataJsonObject = new JSONObject();
        JSONObject detailsJsonObject = new JSONObject();
        try {
            int height;
            int width;
            PackageInfo packageInfo = SdkDetailsHelper.getPackageInfo(context);
            detailsJsonObject.put(SDK_TYPE, (Object)sdkType);
            detailsJsonObject.put(SDK_VERSION, (Object)"2.0.3");
            detailsJsonObject.put(APP_NAME, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getApplicationName(context)));
            detailsJsonObject.put(APP_VERSION, (Object)packageInfo.versionName);
            detailsJsonObject.put(APP_ID, (Object)packageInfo.packageName);
            detailsJsonObject.put(DEVICE_MODEL, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getDeviceName()));
            detailsJsonObject.put("lng", (Object)SdkDetailsHelper.getLanguagesJson());
            detailsJsonObject.put(OS, (Object)ANDROID);
            detailsJsonObject.put(OS_VERSION, (Object)Build.VERSION.RELEASE);
            if (mediatedVia != null) {
                detailsJsonObject.put(MEDIATED_VIA, (Object)mediatedVia);
            }
            detailsJsonObject.put(NETWORK_TYPE, (Object)SdkDetailsHelper.getNetworkClass(context));
            JSONObject screenSize = new JSONObject();
            Display display = SdkDetailsHelper.getDisplay(context);
            if (Build.VERSION.SDK_INT >= 13) {
                Point displaySize = SdkDetailsHelper.getDisplayPoint(display);
                width = displaySize.x;
                height = displaySize.y;
            } else {
                width = display.getWidth();
                height = display.getHeight();
            }
            screenSize.put(WIDTH, width);
            screenSize.put(HEIGHT, height);
            detailsJsonObject.put(SCREEN_SIZE, (Object)screenSize);
            LocationManager locationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
                Location lastKnownLocation = locationManager.getLastKnownLocation("network");
                if (lastKnownLocation != null) {
                    double lat = lastKnownLocation.getLatitude();
                    double lon = lastKnownLocation.getLongitude();
                    JSONObject location = new JSONObject();
                    location.put(LAT, lat);
                    location.put("lng", lon);
                    detailsJsonObject.put(LOCATION, (Object)location);
                    Logger.d(TAG, "location is available");
                } else {
                    Logger.d(TAG, "location is not available");
                }
            } else {
                Logger.d(TAG, "location permission is not granted");
            }
            sdkDataJsonObject.put(SDK_DATA, (Object)detailsJsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdkDataJsonObject;
    }

    private static JSONObject getLanguagesJson() throws JSONException {
        JSONObject languagesJson = new JSONObject();
        JSONArray preferredLanguages = new JSONArray();
        String mainLanguage = Resources.getSystem().getConfiguration().locale.getISO3Language();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = Resources.getSystem().getConfiguration().getLocales();
            for (int i = 0; i < localeList.size(); ++i) {
                preferredLanguages.put((Object)localeList.get(i).getISO3Language());
            }
        } else {
            preferredLanguages.put((Object)mainLanguage);
        }
        languagesJson.put(MAIN_LANGUAGE, (Object)mainLanguage);
        languagesJson.put(PREFERRED_LANGUAGES, (Object)preferredLanguages);
        return languagesJson;
    }

    private static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return SdkDetailsHelper.capitalize(model);
        }
        return SdkDetailsHelper.capitalize(manufacturer) + " " + model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    @RequiresApi(api=13)
    private static Point getDisplayPoint(Display display) {
        Point size = new Point();
        display.getSize(size);
        return size;
    }

    private static Display getDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    public static ScrollView getParentScrollView(View view) {
        for (ViewParent vp = view.getParent(); vp != null; vp = vp.getParent()) {
            if (!(vp instanceof ScrollView)) continue;
            return (ScrollView)vp;
        }
        return null;
    }

    public static int getDisplayHeight(Context context) {
        Display display = SdkDetailsHelper.getDisplay(context);
        Point size = new Point();
        display.getSize(size);
        return size.y;
    }

    public static String getApplicationName(Context context) {
        if (null == sApplicationName) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            sApplicationName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        return sApplicationName;
    }

    private static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        return context.getPackageManager().getPackageInfo(packageName, 0);
    }

    private static String getNetworkClass(Context context) {
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = mTelephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NT_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NT_3G;
            }
            case 13: {
                return NT_4G;
            }
        }
        return NT_WIFI;
    }
}

