/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime.spring.boot;

import com.tailrocks.graphql.datetime.DateScalar;
import com.tailrocks.graphql.datetime.DurationScalar;
import com.tailrocks.graphql.datetime.LocalDateScalar;
import com.tailrocks.graphql.datetime.LocalDateTimeScalar;
import com.tailrocks.graphql.datetime.LocalTimeScalar;
import com.tailrocks.graphql.datetime.OffsetDateTimeScalar;
import com.tailrocks.graphql.datetime.YearMonthScalar;
import com.tailrocks.graphql.datetime.spring.boot.GraphQlDateTimeProperties;
import graphql.schema.GraphQLScalarType;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(beforeName={"graphql.kickstart.autoconfigure.tools.GraphQLJavaToolsAutoConfiguration"})
@EnableConfigurationProperties(value={GraphQlDateTimeProperties.class})
public class GraphQlDateTimeScalarsAutoConfiguration {
    @Bean(name={"graphQlDateScalar"})
    @ConditionalOnMissingBean(name={"graphQlDateScalar"})
    public GraphQLScalarType graphQlDateScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDate().getScalarName();
        return DateScalar.create((String)name);
    }

    @Bean(name={"graphQlLocalDateScalar"})
    @ConditionalOnMissingBean(name={"graphQlLocalDateScalar"})
    public GraphQLScalarType graphQlLocalDateScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDate().getScalarName();
        String format = configurationProperties.getLocalDate().getFormat();
        return LocalDateScalar.create((String)name, (boolean)configurationProperties.isZoneConversionEnabled(), (DateTimeFormatter)(format != null ? DateTimeFormatter.ofPattern(format) : null));
    }

    @Bean(name={"graphQlLocalDateTimeScalar"})
    @ConditionalOnMissingBean(name={"graphQlLocalDateTimeScalar"})
    public GraphQLScalarType graphQlLocalDateTimeScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDateTime().getScalarName();
        String format = configurationProperties.getLocalDateTime().getFormat();
        return LocalDateTimeScalar.create((String)name, (boolean)configurationProperties.isZoneConversionEnabled(), (DateTimeFormatter)(format != null ? DateTimeFormatter.ofPattern(format) : null));
    }

    @Bean(name={"graphQlLocalTimeScalar"})
    @ConditionalOnMissingBean(name={"graphQlLocalTimeScalar"})
    public GraphQLScalarType graphQlLocalTimeScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalTime().getScalarName();
        return LocalTimeScalar.create((String)name);
    }

    @Bean(name={"graphQlOffsetDateTimeScalar"})
    @ConditionalOnMissingBean(name={"graphQlOffsetDateTimeScalar"})
    public GraphQLScalarType graphQlOffsetDateTimeScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getOffsetDateTime().getScalarName();
        return OffsetDateTimeScalar.create((String)name);
    }

    @Bean(name={"graphQlYearMonthScalar"})
    @ConditionalOnMissingBean(name={"graphQlYearMonthScalar"})
    public GraphQLScalarType graphQlYearMonthScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getYearMonth().getScalarName();
        return YearMonthScalar.create((String)name);
    }

    @Bean(name={"graphQlDurationScalar"})
    @ConditionalOnMissingBean(name={"graphQlDurationScalar"})
    public GraphQLScalarType graphQlDurationScalar(GraphQlDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDuration().getScalarName();
        return DurationScalar.create((String)name);
    }
}

