/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.LocalDateTimeConverter;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Internal
public class GraphqlLocalDateCoercing
implements Coercing<LocalDate, String> {
    private final DateTimeFormatter formatter;
    private final LocalDateTimeConverter converter;

    public GraphqlLocalDateCoercing(boolean zoneConversionEnabled, DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.converter = new LocalDateTimeConverter(zoneConversionEnabled, formatter);
    }

    private LocalDate convertImpl(Object input) {
        if (input instanceof String) {
            LocalDateTime localDateTime = this.converter.parseDate((String)input);
            if (localDateTime != null) {
                return localDateTime.toLocalDate();
            }
        } else if (input instanceof LocalDate) {
            return (LocalDate)input;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof LocalDate) {
            return this.converter.formatDate((LocalDate)input, this.formatter);
        }
        LocalDate result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Invalid value '" + input + "' for LocalDate");
        }
        return this.converter.formatDate(result, this.formatter);
    }

    public LocalDate parseValue(Object input) {
        LocalDate result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Invalid value '" + input + "' for LocalDate");
        }
        return result;
    }

    public LocalDate parseLiteral(Object input) {
        String value = ((StringValue)input).getValue();
        LocalDate result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException("Invalid value '" + input + "' for LocalDate");
        }
        return result;
    }
}

