/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

@Internal
public class GraphqlOffsetDateTimeCoercing
implements Coercing<OffsetDateTime, String> {
    private OffsetDateTime convertImpl(Object input) {
        if (input instanceof String) {
            try {
                return OffsetDateTime.parse((String)input, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (input instanceof OffsetDateTime) {
            return (OffsetDateTime)input;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof OffsetDateTime) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)input);
        }
        OffsetDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Invalid value '" + input + "' for OffsetDateTime");
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(result);
    }

    public OffsetDateTime parseValue(Object input) {
        OffsetDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Invalid value '" + input + "' for OffsetDateTime");
        }
        return result;
    }

    public OffsetDateTime parseLiteral(Object input) {
        String value = ((StringValue)input).getValue();
        OffsetDateTime result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException("Invalid value '" + input + "' for OffsetDateTime");
        }
        return result;
    }
}

