/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.CoercingUtil;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.Duration;
import java.time.format.DateTimeParseException;

@Internal
public class GraphqlDurationCoercing
implements Coercing<Duration, String> {
    public String serialize(Object input) {
        if (input instanceof Duration) {
            Duration duration = (Duration)input;
            return duration.toString();
        }
        Duration result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(this.getErrorMessage(input));
        }
        return result.toString();
    }

    public Duration parseValue(Object input) {
        Duration result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(this.getErrorMessage(input));
        }
        return result;
    }

    public Duration parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        Duration result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException(this.getErrorMessage(input));
        }
        return result;
    }

    private Duration convertImpl(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            try {
                return Duration.parse(string);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (input instanceof Duration) {
            Duration duration = (Duration)input;
            return duration;
        }
        return null;
    }

    private String getErrorMessage(Object input) {
        return "Invalid value '" + input + "' for Duration";
    }
}

